/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.codegen.dthelpers;

import java.util.regex.Pattern;
import org.faktorips.codegen.DatatypeHelper;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.codegen.dthelpers.AbstractPrimitiveDatatypeHelper;
import org.faktorips.datatype.PrimitiveLongDatatype;

public class PrimitiveLongHelper
extends AbstractPrimitiveDatatypeHelper {
    private static final String L = "L";
    private static final Pattern DIGITS = Pattern.compile("[0-9+-]+");

    public PrimitiveLongHelper() {
    }

    public PrimitiveLongHelper(PrimitiveLongDatatype datatype) {
        super(datatype);
    }

    @Override
    public DatatypeHelper getWrapperTypeHelper() {
        return DatatypeHelper.LONG;
    }

    @Override
    public String getJavaClassName() {
        return Long.TYPE.getName();
    }

    @Override
    public JavaCodeFragment newInstance(String value) {
        return new JavaCodeFragment(PrimitiveLongHelper.longLiteral(value));
    }

    protected static String longLiteral(String value) {
        long longValue;
        Object longLiteral = value;
        if (longLiteral != null && ((String)longLiteral).length() > 1 && DIGITS.matcher((CharSequence)longLiteral).matches() && ((longValue = Long.parseLong((String)longLiteral)) > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE)) {
            longLiteral = (String)longLiteral + L;
        }
        return longLiteral;
    }

    @Override
    public JavaCodeFragment toWrapper(JavaCodeFragment expression) {
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.appendClassName(Long.class);
        fragment.append(".valueOf(");
        fragment.append(expression);
        fragment.append(')');
        return fragment;
    }

    @Override
    protected JavaCodeFragment valueOfExpression(String expression) {
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.append("Long.parseLong(" + PrimitiveLongHelper.longLiteral(expression) + ")");
        return fragment;
    }
}

