/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.datatype;

import java.util.Objects;
import org.faktorips.datatype.AbstractDatatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.values.NullObjectSupport;

public abstract class ValueClassNameDatatype
extends AbstractDatatype
implements ValueDatatype {
    private String name;

    public ValueClassNameDatatype(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return this.name;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public final boolean isImmutable() {
        return !this.isMutable();
    }

    @Override
    public boolean isValueDatatype() {
        return true;
    }

    @Override
    public String getDefaultValue() {
        return null;
    }

    @Override
    public ValueDatatype getWrapperType() {
        return null;
    }

    @Override
    public String valueToString(Object value) {
        return value.toString();
    }

    @Override
    public boolean isNull(String valueString) {
        Object value;
        try {
            value = this.getValue(valueString);
        }
        catch (Exception e) {
            return false;
        }
        if (value == null) {
            return true;
        }
        if (!(value instanceof NullObjectSupport)) {
            return false;
        }
        return ((NullObjectSupport)value).isNull();
    }

    @Override
    public boolean isParsable(String value) {
        try {
            if (this.isNull(value)) {
                return true;
            }
            this.getValue(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public boolean hasNullObject() {
        return false;
    }

    @Override
    public boolean areValuesEqual(String valueA, String valueB) {
        return Objects.equals(this.getValue(valueA), this.getValue(valueB));
    }

    @Override
    public int compare(String valueA, String valueB) {
        if (!this.supportsCompare()) {
            throw new UnsupportedOperationException("Datatype " + this.getQualifiedName() + " does not support comparison of values");
        }
        if (this.areValuesEqual(valueA, valueB)) {
            return 0;
        }
        Comparable valA = (Comparable)this.getValue(valueA);
        if (valA == null) {
            return -1;
        }
        Object valB = this.getValue(valueB);
        if (valB == null) {
            return 1;
        }
        return valA.compareTo(valB);
    }

    @Override
    public abstract Object getValue(String var1);
}

