/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.codegen.dthelpers;

import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.codegen.dthelpers.AbstractDatatypeHelper;
import org.faktorips.datatype.GenericValueDatatype;

public class GenericValueDatatypeHelper
extends AbstractDatatypeHelper {
    public GenericValueDatatypeHelper(GenericValueDatatype datatype) {
        super(datatype);
    }

    @Override
    public GenericValueDatatype getDatatype() {
        return (GenericValueDatatype)super.getDatatype();
    }

    @Override
    public String getJavaClassName() {
        return this.getDatatype().getJavaClassName();
    }

    @Override
    protected JavaCodeFragment valueOfExpression(String expression) {
        JavaCodeFragment code = new JavaCodeFragment();
        code.appendClassName(this.getDatatype().getJavaClassName());
        code.append('.');
        code.append(this.getDatatype().getValueOfMethodName());
        code.append('(');
        code.append(expression);
        code.append(')');
        return code;
    }

    @Override
    public JavaCodeFragment nullExpression() {
        GenericValueDatatype datatype = this.getDatatype();
        JavaCodeFragment code = new JavaCodeFragment();
        if (!datatype.hasNullObject()) {
            code.append("null");
            return code;
        }
        code.appendClassName(datatype.getJavaClassName());
        code.append('.');
        code.append(datatype.getValueOfMethodName());
        code.append('(');
        if (datatype.getNullObjectId() == null) {
            code.append("null");
        } else {
            code.appendQuoted(datatype.getNullObjectId());
        }
        code.append(')');
        return code;
    }

    @Override
    public JavaCodeFragment newInstance(String value) {
        if (value == null) {
            return this.nullExpression();
        }
        return this.valueOfExpression("\"" + value + "\"");
    }

    @Override
    public JavaCodeFragment getToStringExpression(String fieldName) {
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.append(fieldName);
        fragment.append("==null?null:");
        fragment.append(fieldName);
        fragment.append(".");
        fragment.append(this.getDatatype().getToStringMethodName());
        fragment.append("()");
        return fragment;
    }
}

