/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.datatype.classtypes;

import java.math.RoundingMode;
import org.faktorips.datatype.NumericDatatype;
import org.faktorips.datatype.ValueClassNameDatatype;
import org.faktorips.values.Money;

public class MoneyDatatype
extends ValueClassNameDatatype
implements NumericDatatype {
    public MoneyDatatype() {
        super(Money.class.getSimpleName());
    }

    public Money getValue(String s) {
        return Money.valueOf((String)s);
    }

    @Override
    public boolean hasNullObject() {
        return true;
    }

    @Override
    public boolean supportsCompare() {
        return true;
    }

    @Override
    public String subtract(String minuend, String subtrahend) {
        if (minuend == null || subtrahend == null) {
            throw new NullPointerException("Minuend and subtrahend both can not be null.");
        }
        return Money.valueOf((String)minuend).subtract(Money.valueOf((String)subtrahend)).toString();
    }

    @Override
    public boolean divisibleWithoutRemainder(String dividend, String divisor) {
        if (dividend == null || divisor == null) {
            throw new NullPointerException("dividend and divisor both can not be null.");
        }
        Money a = Money.valueOf((String)dividend);
        Money b = Money.valueOf((String)divisor);
        try {
            a.getAmount().divide(b.getAmount(), 0, RoundingMode.UNNECESSARY);
        }
        catch (ArithmeticException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean hasDecimalPlaces() {
        return true;
    }
}

