/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.codegen.dthelpers.joda;

import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.codegen.dthelpers.ILocalDateHelper;
import org.faktorips.codegen.dthelpers.joda.BaseJodaDatatypeHelper;
import org.faktorips.datatype.joda.LocalDateDatatype;

public class LocalDateHelper
extends BaseJodaDatatypeHelper
implements ILocalDateHelper {
    public static final String ORG_JODA_TIME_LOCAL_DATE = "org.joda.time.LocalDate";
    private static final String YEAR = "year()";
    private static final String MONTH_OF_YEAR = "monthOfYear()";
    private static final String DAY_OF_MONTH = "dayOfMonth()";
    private static final String ORG_JODA_TIME_DATE_TIME_FIELD_TYPE = "org.joda.time.DateTimeFieldType";
    private static final String DAYS_HELPER_CLASS = "org.joda.time.Days";
    private static final String WEEKS_HELPER_CLASS = "org.joda.time.Weeks";
    private static final String MONTHS_HELPER_CLASS = "org.joda.time.Months";
    private static final String YEARS_HELPER_CLASS = "org.joda.time.Years";
    private static final String PARSE_METHOD = "toLocalDate";

    public LocalDateHelper() {
        super(ORG_JODA_TIME_LOCAL_DATE, PARSE_METHOD);
    }

    public LocalDateHelper(LocalDateDatatype d) {
        super(d, ORG_JODA_TIME_LOCAL_DATE, PARSE_METHOD);
    }

    @Override
    public JavaCodeFragment getPeriodCode(JavaCodeFragment arg1, JavaCodeFragment arg2, ILocalDateHelper.Period period) {
        JavaCodeFragment fragment = new JavaCodeFragment();
        switch (period) {
            case DAYS: {
                fragment.appendClassName(DAYS_HELPER_CLASS).append(".daysBetween");
                break;
            }
            case WEEKS: {
                fragment.appendClassName(WEEKS_HELPER_CLASS).append(".weeksBetween");
                break;
            }
            case MONTHS: {
                fragment.appendClassName(MONTHS_HELPER_CLASS).append(".monthsBetween");
                break;
            }
            case YEARS: {
                fragment.appendClassName(YEARS_HELPER_CLASS).append(".yearsBetween");
                break;
            }
        }
        fragment.append("(").append(arg1).append(", ").append(arg2).append(")");
        switch (period) {
            case DAYS: {
                fragment.append(".getDays()");
                break;
            }
            case WEEKS: {
                fragment.append(".getWeeks()");
                break;
            }
            case MONTHS: {
                fragment.append(".getMonths()");
                break;
            }
            case YEARS: {
                fragment.append(".getYears()");
                break;
            }
        }
        return fragment;
    }

    @Override
    public JavaCodeFragment getDateInitialization(JavaCodeFragment year, JavaCodeFragment month, JavaCodeFragment day) {
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.append("new ").appendClassName(this.getJavaClassName()).append("(").append(year).append(", ").append(month).append(", ").append(day).append(")");
        return fragment;
    }

    @Override
    public String getDateFieldEnumClass() {
        return ORG_JODA_TIME_DATE_TIME_FIELD_TYPE;
    }

    @Override
    public String getDayOfMonthField() {
        return DAY_OF_MONTH;
    }

    @Override
    public String getMonthOfYearField() {
        return MONTH_OF_YEAR;
    }

    @Override
    public String getYearField() {
        return YEAR;
    }
}

