/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.datatype;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.EnumDatatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.datatype.util.DatatypeComparator;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.MethodAccess;
import org.faktorips.util.StringUtil;
import org.faktorips.values.NullObjectSupport;

public abstract class GenericValueDatatype
implements ValueDatatype {
    public static final String MSGCODE_PREFIX = "GENERIC DATATYPE-";
    public static final String MSGCODE_JAVACLASS_NOT_FOUND = "GENERIC DATATYPE-Java class not found";
    public static final String MSGCODE_PREFIX_GET_VALUE_METHOD = "GENERIC DATATYPE-getValueMethod";
    public static final String MSGCODE_PREFIX_IS_PARSABLE_METHOD = "GENERIC DATATYPE-isParsable";
    public static final String MSGCODE_PREFIX_TO_STRING_METHOD = "GENERIC DATATYPE-toString";
    public static final String MSGCODE_PREFIX_VALUE_OF_METHOD = "GENERIC DATATYPE-valueOf";
    public static final String MSGCODE_SPECIALCASE_NULL_NOT_FOUND = "GENERIC DATATYPE-Special case null not found";
    public static final String MSGCODE_SPECIALCASE_NULL_IS_NOT_NULL = "GENERIC DATATYPE-Special case null is not null";
    public static final String MSGCODE_GETVALUE_METHOD_NOT_FOUND = "GENERIC DATATYPE-getValueMethod_NOT_FOUND";
    public static final String MSGCODE_ISPARSABLE_METHOD_NOT_FOUND = "GENERIC DATATYPE-isParsable_NOT_FOUND";
    public static final String MSGCODE_TOSTRING_METHOD_NOT_FOUND = "GENERIC DATATYPE-toString_NOT_FOUND";
    public static final String MSGCODE_VALUE_OF_METHOD_NOT_FOUND = "GENERIC DATATYPE-valueOf_NOT_FOUND";
    public static final String MSGCODE_PREFIX_GET_ALL_VALUES_METHOD = "GENERIC DATATYPE-getAllValuesMethod";
    public static final String MSGCODE_GET_ALL_VALUES_METHOD_NOT_FOUND = "GENERIC DATATYPE-getAllValuesMethod_NOT_FOUND";
    private String qualifiedName;
    private String valueOfMethodName = "valueOf";
    private String isParsableMethodName = "isParsable";
    private String toStringMethodName = "toString";
    private String getAllValuesMethodName = "";
    private boolean nullObjectDefined = false;
    private String nullObjectId = null;

    @Override
    public String getDefaultValue() {
        return null;
    }

    public abstract Class<?> getAdaptedClass();

    public abstract String getAdaptedClassName();

    @Override
    public MessageList checkReadyToUse() {
        MessageList list = new MessageList();
        if (this.getAdaptedClass() == null) {
            String text = "The Java class represented by the datatype can't be found. (Classname: " + this.getAdaptedClassName() + "). Either the class is not on the classpath or the resource it is stored in is out of sync. See error log for more details.";
            if (this.getAdaptedClassName() != null) {
                list.add(Message.newError((String)MSGCODE_JAVACLASS_NOT_FOUND, (String)text, (Object)this.getAdaptedClassName(), (String[])new String[0]));
            } else {
                list.add(Message.newError((String)MSGCODE_JAVACLASS_NOT_FOUND, (String)text));
            }
            return list;
        }
        this.checkIsParsableMethodName(list);
        this.checkToStringMethodName(list);
        this.checkNullObjectDefined(list);
        this.checkValueOfMethodName(list);
        this.checkGetAllValues(list);
        return list;
    }

    private MethodAccess getValueOfMethod() {
        return MethodAccess.of(this.getAdaptedClass(), (String)this.getValueOfMethodName(), (Class[])new Class[]{CharSequence.class});
    }

    private void checkValueOfMethodName(MessageList list) {
        if (IpsStringUtils.isBlank((String)this.getValueOfMethodName()) && IpsStringUtils.isBlank((String)this.getAllValuesMethodName())) {
            list.add(Message.newError((String)MSGCODE_VALUE_OF_METHOD_NOT_FOUND, (String)("valueOfMethod must be configured for the datatype " + this.getName() + " if no getAllValuesMethod is configured.")));
        }
        if (this.valueOfMethodName != null) {
            this.getValueOfMethod().check(list, MSGCODE_PREFIX_GET_VALUE_METHOD).exists().isStatic().returnTypeIsCompatible(new Class[]{this.getAdaptedClass()});
        }
    }

    private MethodAccess getIsParsableMethod() {
        return MethodAccess.of(this.getAdaptedClass(), (String)this.getIsParsableMethodName(), (Class[])new Class[]{CharSequence.class});
    }

    private void checkIsParsableMethodName(MessageList list) {
        if (this.isParsableMethodName != null) {
            this.getIsParsableMethod().check(list, MSGCODE_PREFIX_IS_PARSABLE_METHOD).exists().isStatic().returnTypeIsCompatible(new Class[]{Boolean.TYPE});
        }
    }

    protected MethodAccess getToStringMethod() {
        return MethodAccess.of(this.getAdaptedClass(), (String)this.getToStringMethodName(), (Class[])new Class[0]);
    }

    private void checkToStringMethodName(MessageList list) {
        if (this.toStringMethodName != null) {
            this.getToStringMethod().check(list, MSGCODE_PREFIX_TO_STRING_METHOD).exists().isNotStatic().returnTypeIsCompatible(new Class[]{String.class});
        }
    }

    private void checkNullObjectDefined(MessageList list) {
        if (this.nullObjectDefined) {
            try {
                Object value = this.getValue(this.nullObjectId);
                if (value instanceof NullObjectSupport && !((NullObjectSupport)value).isNull()) {
                    String text = "The string " + this.nullObjectId + " does not represent the special null value.";
                    list.add(Message.newError((String)MSGCODE_SPECIALCASE_NULL_IS_NOT_NULL, (String)text));
                }
            }
            catch (RuntimeException e) {
                String text = "The null value string " + this.nullObjectId + " is not a value defined by the datatype.";
                list.add(Message.newError((String)MSGCODE_SPECIALCASE_NULL_NOT_FOUND, (String)text));
            }
        }
    }

    public String getIsParsableMethodName() {
        return this.isParsableMethodName;
    }

    public void setIsParsableMethodName(String isParsableMethodName) {
        this.isParsableMethodName = isParsableMethodName;
    }

    @Override
    public boolean hasNullObject() {
        return this.nullObjectDefined;
    }

    public void setNullObjectDefined(boolean flag) {
        this.nullObjectDefined = flag;
    }

    @Override
    public String getNullObjectId() {
        return this.nullObjectId;
    }

    public void setNullObjectId(String specialNullValueId) {
        this.nullObjectId = specialNullValueId;
    }

    public String getValueOfMethodName() {
        return this.valueOfMethodName;
    }

    public void setValueOfMethodName(String valueOfMethodName) {
        this.valueOfMethodName = valueOfMethodName;
    }

    public String getToStringMethodName() {
        return this.toStringMethodName;
    }

    public void setToStringMethodName(String toStringMethodName) {
        this.toStringMethodName = toStringMethodName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    @Override
    public ValueDatatype getWrapperType() {
        return null;
    }

    @Override
    public boolean isParsable(String value) {
        if (value == null) {
            return true;
        }
        if (this.getIsParsableMethodName() != null) {
            return (Boolean)this.getIsParsableMethod().invokeStatic("to check whether a String is parsable", new Object[]{value});
        }
        try {
            this.getValueOfMethod().invokeStatic("to create a " + this.getAdaptedClassName() + " from a String", new Object[]{value});
            return true;
        }
        catch (MethodAccess.MethodAccessException e) {
            return false;
        }
    }

    @Override
    public Object getValue(String value) {
        if (!this.nullObjectDefined && value == null) {
            return null;
        }
        if (IpsStringUtils.isBlank((String)this.valueOfMethodName)) {
            return this.findValueInAllValues(value);
        }
        return this.getValueOfMethod().invokeStatic("to get a value", new Object[]{value});
    }

    private Object findValueInAllValues(String value) {
        Object result = this.getAllValuesMethod().invokeStatic("to get all values", new Object[0]);
        Object[] values = result instanceof Collection ? ((Collection)result).toArray(Object[]::new) : (Object[])result;
        return Arrays.stream(values).filter(v -> Objects.equals(value, this.valueToString(v))).findFirst().orElseThrow(() -> new IllegalArgumentException(value + " could not be found in all values."));
    }

    @Override
    public String valueToString(Object value) {
        if (this.getToStringMethodName() == null) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }
        return (String)this.getToStringMethod().invoke("to get the String representation", value, new Object[0]);
    }

    @Override
    public boolean isNull(String value) {
        if (value == null) {
            return true;
        }
        if (!this.nullObjectDefined) {
            return false;
        }
        return value.equals(this.getValue(this.nullObjectId));
    }

    @Override
    public boolean isEnum() {
        return this instanceof EnumDatatype;
    }

    @Override
    public String getName() {
        return StringUtil.unqualifiedName((String)this.qualifiedName);
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Datatype)) {
            return false;
        }
        return this.getQualifiedName().equals(((Datatype)o).getQualifiedName());
    }

    @Override
    public boolean isVoid() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isValueDatatype() {
        return true;
    }

    public String getJavaClassName() {
        return this.getAdaptedClass().getName();
    }

    @Override
    public int compareTo(Datatype o) {
        return DatatypeComparator.doCompare(this, o);
    }

    public String toString() {
        return this.qualifiedName;
    }

    protected void clearCache() {
    }

    @Override
    public boolean areValuesEqual(String valueA, String valueB) {
        if (valueA == null && valueB == null) {
            return true;
        }
        if (valueA == null == (valueB != null)) {
            return false;
        }
        return this.getValue(valueA).equals(this.getValue(valueB));
    }

    @Override
    public int compare(String valueA, String valueB) {
        if (!this.supportsCompare()) {
            throw new UnsupportedOperationException("The class " + this.getAdaptedClassName() + " does not implement " + Comparable.class.getName());
        }
        Comparable value = (Comparable)this.getValue(valueA);
        Object value2 = this.getValue(valueB);
        return value.compareTo(value2);
    }

    @Override
    public boolean supportsCompare() {
        return Comparable.class.isAssignableFrom(this.getAdaptedClass());
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    private void checkGetAllValues(MessageList ml) {
        if (IpsStringUtils.isBlank((String)this.getAllValuesMethodName())) {
            if (this instanceof EnumDatatype) {
                ml.add(Message.newError((String)MSGCODE_GET_ALL_VALUES_METHOD_NOT_FOUND, (String)("getAllValuesMethod must be configured for the enum datatype " + this.getName())));
            }
            return;
        }
        this.getAllValuesMethod().check(ml, MSGCODE_PREFIX_GET_ALL_VALUES_METHOD).exists().isStatic().returnTypeIsCompatible(new Class[]{Object[].class, Collection.class});
    }

    public MethodAccess getAllValuesMethod() {
        return MethodAccess.of(this.getAdaptedClass(), (String)this.getAllValuesMethodName(), (Class[])new Class[0]);
    }

    public void setAllValuesMethodName(String getAllValuesMethodName) {
        this.getAllValuesMethodName = getAllValuesMethodName;
    }

    public String getAllValuesMethodName() {
        return this.getAllValuesMethodName;
    }
}

