/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.datatype;

import java.util.Objects;
import org.faktorips.datatype.AbstractDatatype;
import org.faktorips.datatype.AnyDatatype;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.util.ArgumentCheck;

public class ListOfTypeDatatype
extends AbstractDatatype
implements ValueDatatype {
    private final Datatype basicType;

    public ListOfTypeDatatype(Datatype basicType) {
        ArgumentCheck.notNull((Object)basicType);
        this.basicType = basicType.isPrimitive() && basicType instanceof ValueDatatype ? ((ValueDatatype)basicType).getWrapperType() : basicType;
    }

    public Datatype getBasicDatatype() {
        return this.basicType;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder("List");
        sb.append('<');
        sb.append(this.basicType.getName());
        sb.append('>');
        return sb.toString();
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return this.basicType.isAbstract();
    }

    @Override
    public String getDefaultValue() {
        return null;
    }

    @Override
    public boolean isValueDatatype() {
        return true;
    }

    @Override
    public ValueDatatype getWrapperType() {
        return null;
    }

    @Override
    public boolean isParsable(String value) {
        return value == null;
    }

    @Override
    public Object getValue(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean matchDatatype(Datatype datatype) {
        if (super.matchDatatype(datatype)) {
            return true;
        }
        if (datatype instanceof ListOfTypeDatatype) {
            ListOfTypeDatatype otherListOfTypeDatatype = (ListOfTypeDatatype)datatype;
            if (otherListOfTypeDatatype.getBasicDatatype() instanceof AnyDatatype) {
                return true;
            }
            return otherListOfTypeDatatype.getBasicDatatype().equals(this.getBasicDatatype());
        }
        return false;
    }

    @Override
    public boolean isNull(String value) {
        return value == null;
    }

    @Override
    public boolean supportsCompare() {
        return this.basicType.isValueDatatype() && ((ValueDatatype)this.basicType).supportsCompare();
    }

    @Override
    public int compare(String valueA, String valueB) {
        if (!this.supportsCompare()) {
            throw new UnsupportedOperationException("The basicType " + this.basicType.getQualifiedName() + " does not support comparison for values.");
        }
        return ((ValueDatatype)this.basicType).compare(valueA, valueB);
    }

    @Override
    public boolean areValuesEqual(String valueA, String valueB) {
        if (this.basicType.isValueDatatype()) {
            return ((ValueDatatype)this.basicType).areValuesEqual(valueA, valueB);
        }
        return Objects.equals(valueA, valueB);
    }
}

