/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.datatype.classtypes;

import org.faktorips.datatype.NumericDatatype;
import org.faktorips.datatype.ValueClassNameDatatype;
import org.faktorips.runtime.internal.IpsStringUtils;

public class IntegerDatatype
extends ValueClassNameDatatype
implements NumericDatatype {
    public IntegerDatatype() {
        super(Integer.class.getSimpleName());
    }

    @Override
    public Object getValue(String s) {
        if (IpsStringUtils.isEmpty((String)s)) {
            return null;
        }
        return Integer.valueOf(s);
    }

    @Override
    public boolean supportsCompare() {
        return true;
    }

    @Override
    public String subtract(String minuend, String subtrahend) {
        if (minuend == null || subtrahend == null) {
            throw new NullPointerException("Minuend and subtrahend both can not be null.");
        }
        int result = (Integer)this.getValue(minuend) - (Integer)this.getValue(subtrahend);
        return Integer.toString(result);
    }

    @Override
    public boolean divisibleWithoutRemainder(String dividend, String divisor) {
        if (dividend == null || divisor == null) {
            throw new NullPointerException("dividend and divisor both can not be null.");
        }
        Integer intA = (Integer)this.getValue(dividend);
        Integer intB = (Integer)this.getValue(divisor);
        if (intA == null) {
            throw new NumberFormatException("The dividend '" + dividend + "' can not be parsed to an Integer");
        }
        if (intB == null) {
            throw new NumberFormatException("The divisor '" + divisor + "' can not be parsed to an Integer");
        }
        int a = intA;
        int b = intB;
        return b == 0 ? false : a % b == 0;
    }

    @Override
    public boolean hasDecimalPlaces() {
        return false;
    }
}

