/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.codegen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.faktorips.util.StringUtil;

public class ImportDeclaration {
    private static final String JAVA_LANG_ASTERIX = "java.lang.*";
    private List<String> classes = new ArrayList<String>();
    private List<String> packages = new ArrayList<String>();

    public ImportDeclaration() {
    }

    public ImportDeclaration(ImportDeclaration decl) {
        this();
        this.add(decl);
    }

    public ImportDeclaration(ImportDeclaration decl, String packageName) {
        this();
        String packageImport = packageName + ".*";
        ImportDeclaration temp = new ImportDeclaration(decl);
        temp.add(packageImport);
        Iterator<String> it = temp.iterator();
        while (it.hasNext()) {
            String importSpec = it.next();
            if (importSpec.equals(packageImport)) continue;
            this.add(importSpec);
        }
    }

    public static final boolean isPackageImport(String importSpec) {
        if (importSpec == null) {
            return false;
        }
        return "*".equals(importSpec.substring(importSpec.length() - 1));
    }

    public void add(Class<?> clazz) {
        this.add(clazz.getName());
    }

    public void add(ImportDeclaration decl) {
        if (decl == null) {
            return;
        }
        Iterator<String> it = decl.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public void add(String[] importSpecs) {
        if (importSpecs == null) {
            return;
        }
        for (String importSpec : importSpecs) {
            this.add(importSpec);
        }
    }

    public void add(String importSpec) {
        if (importSpec == null || this.isCovered(importSpec)) {
            return;
        }
        if (ImportDeclaration.isPackageImport(importSpec)) {
            this.removeClassImports(importSpec);
            this.packages.add(importSpec);
        } else {
            this.classes.add(importSpec);
        }
    }

    private void removeClassImports(String packageImport) {
        Iterator<String> it = this.classes.iterator();
        while (it.hasNext()) {
            String classImport = it.next();
            if (!this.classImportCoveredByPackageImport(classImport, packageImport)) continue;
            it.remove();
        }
    }

    public boolean isCovered(Class<?> clazz) {
        return this.isCovered(clazz.getName());
    }

    public boolean isCovered(String importSpec) {
        if (importSpec == null) {
            throw new NullPointerException();
        }
        if (importSpec.equals(Boolean.TYPE.getName()) || importSpec.equals(Integer.TYPE.getName()) || importSpec.equals(Double.TYPE.getName()) || importSpec.equals(Long.TYPE.getName()) || "void".equals(importSpec)) {
            return true;
        }
        if (ImportDeclaration.isPackageImport(importSpec)) {
            if (JAVA_LANG_ASTERIX.equals(importSpec)) {
                return true;
            }
            return this.packages.contains(importSpec);
        }
        if (this.classes.contains(importSpec)) {
            return true;
        }
        return this.isCovered(StringUtil.getPackageName((String)importSpec) + ".*");
    }

    private boolean classImportCoveredByPackageImport(String classImport, String packageImport) {
        return (StringUtil.getPackageName((String)classImport) + ".*").equals(packageImport);
    }

    public Iterator<String> iterator() {
        return this.getImports().iterator();
    }

    public Set<String> getImports() {
        LinkedHashSet<String> allImports = new LinkedHashSet<String>();
        allImports.addAll(this.packages);
        allImports.addAll(this.classes);
        return allImports;
    }

    public int getNoOfImports() {
        return this.classes.size() + this.packages.size();
    }

    public ImportDeclaration getUncoveredImports(ImportDeclaration importsToTest) {
        ImportDeclaration uncovered = new ImportDeclaration();
        if (importsToTest == null) {
            return uncovered;
        }
        Iterator<String> it = importsToTest.iterator();
        while (it.hasNext()) {
            String importToTest = it.next();
            if (this.isCovered(importToTest)) continue;
            uncovered.add(importToTest);
        }
        return uncovered;
    }

    public int hashCode() {
        return Objects.hash(this.classes, this.packages);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImportDeclaration)) {
            return false;
        }
        ImportDeclaration other = (ImportDeclaration)obj;
        return Objects.equals(this.classes, other.classes) && Objects.equals(this.packages, other.packages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String separator = System.lineSeparator();
        Iterator<String> it = this.iterator();
        while (it.hasNext()) {
            sb.append("import ");
            sb.append(it.next());
            sb.append(";");
            sb.append(separator);
        }
        return sb.toString();
    }
}

