/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.datatype.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.faktorips.util.ArgumentCheck;

public class LocalizedStringsSet {
    private String name;
    private ClassLoader loader;

    public LocalizedStringsSet(Class<?> clazz) {
        this(clazz.getName(), clazz.getClassLoader());
    }

    public LocalizedStringsSet(String qualifiedName, ClassLoader loader) {
        ArgumentCheck.notNull((Object)qualifiedName);
        ArgumentCheck.notNull((Object)loader);
        this.name = qualifiedName;
        this.loader = loader;
    }

    public boolean isAccessible(Locale locale) {
        try {
            ResourceBundle.getBundle(this.name, locale, this.loader);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public String getString(String key, Locale locale, Object ... replacements) {
        String s = ResourceBundle.getBundle(this.name, locale, this.loader).getString(key);
        MessageFormat mf = new MessageFormat(s, locale);
        return mf.format(replacements);
    }

    public String getString(String key, Locale locale) {
        return ResourceBundle.getBundle(this.name, locale, this.loader).getString(key);
    }

    public String getString(String key, Object ... replacements) {
        return this.getString(key, Locale.getDefault(), replacements);
    }

    public String getString(String key) {
        return ResourceBundle.getBundle(this.name, Locale.getDefault(), this.loader).getString(key);
    }
}

