/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.datatype.classtypes;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.faktorips.datatype.NumericDatatype;
import org.faktorips.datatype.ValueClassNameDatatype;
import org.faktorips.runtime.internal.IpsStringUtils;

public class DoubleDatatype
extends ValueClassNameDatatype
implements NumericDatatype {
    public DoubleDatatype() {
        super(Double.class.getSimpleName());
    }

    @Override
    public Object getValue(String s) {
        if (IpsStringUtils.isEmpty((String)s)) {
            return null;
        }
        return Double.valueOf(s);
    }

    @Override
    public boolean supportsCompare() {
        return true;
    }

    @Override
    public String subtract(String minuend, String subtrahend) {
        if (minuend == null || subtrahend == null) {
            throw new NullPointerException("Minuend and subtrahend both can not be null.");
        }
        double result = (Double)this.getValue(minuend) - (Double)this.getValue(subtrahend);
        return Double.toString(result);
    }

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    public boolean divisibleWithoutRemainder(String dividend, String divisor) {
        if (dividend == null || divisor == null) {
            throw new NullPointerException("dividend and divisor both can not be null.");
        }
        BigDecimal a = new BigDecimal(dividend);
        BigDecimal b = new BigDecimal(divisor);
        try {
            a.divide(b, 0, RoundingMode.UNNECESSARY);
            return true;
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    @Override
    public boolean hasDecimalPlaces() {
        return true;
    }
}

