/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.datatype;

import org.faktorips.datatype.AbstractPrimitiveDatatype;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.NumericDatatype;
import org.faktorips.datatype.ValueDatatype;

public class PrimitiveIntegerDatatype
extends AbstractPrimitiveDatatype
implements NumericDatatype {
    @Override
    public String getName() {
        return "int";
    }

    @Override
    public String getQualifiedName() {
        return "int";
    }

    @Override
    public ValueDatatype getWrapperType() {
        return Datatype.INTEGER;
    }

    @Override
    public String getDefaultValue() {
        return "0";
    }

    @Override
    public Object getValue(String value) {
        return Integer.valueOf(value);
    }

    @Override
    public boolean supportsCompare() {
        return true;
    }

    @Override
    public String subtract(String minuend, String subtrahend) {
        if (minuend == null || subtrahend == null) {
            throw new NullPointerException("Minuend and subtrahend both can not be null.");
        }
        int result = (Integer)this.getValue(minuend) - (Integer)this.getValue(subtrahend);
        return Integer.toString(result);
    }

    @Override
    public boolean divisibleWithoutRemainder(String dividend, String divisor) {
        if (dividend == null || divisor == null) {
            throw new NullPointerException("dividend and divisor both can not be null.");
        }
        int a = (Integer)this.getValue(dividend);
        int b = (Integer)this.getValue(divisor);
        return b == 0 ? false : a % b == 0;
    }

    @Override
    public boolean hasDecimalPlaces() {
        return false;
    }
}

