/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.datatype.joda;

import java.util.regex.Pattern;
import org.faktorips.datatype.ValueClassNameDatatype;
import org.faktorips.runtime.internal.IpsStringUtils;

public class MonthDayDatatype
extends ValueClassNameDatatype {
    public static final MonthDayDatatype DATATYPE = new MonthDayDatatype();
    public static final String NAME = "MonthDay";
    private static final Pattern PATERN_ISO_MONTH_DAY = Pattern.compile("^--\\d{2}-\\d{2}$");

    public MonthDayDatatype() {
        super(NAME);
    }

    @Override
    public Object getValue(String value) {
        return value;
    }

    @Override
    public boolean supportsCompare() {
        return true;
    }

    @Override
    public boolean isParsable(String value) {
        return IpsStringUtils.isEmpty((String)value) || this.isIsoMonthDay(value);
    }

    private boolean isIsoMonthDay(String value) {
        return value == null ? false : PATERN_ISO_MONTH_DAY.matcher(value).matches();
    }
}

