/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.datatype.classtypes;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.faktorips.datatype.ValueClassNameDatatype;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.values.DateUtil;

public class DateDatatype
extends ValueClassNameDatatype {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static ThreadLocal<SimpleDateFormat> formatter = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_FORMAT));

    public DateDatatype() {
        super(Date.class.getSimpleName());
    }

    @Override
    public Object getValue(String value) {
        if (IpsStringUtils.isEmpty((String)value)) {
            return null;
        }
        try {
            if (!DateUtil.isIsoDate((String)value)) {
                throw new IllegalArgumentException("Date value must have the format yyyy-MM-dd");
            }
            return formatter.get().parse(value);
        }
        catch (Exception e) {
            IllegalArgumentException ill = new IllegalArgumentException("Unable to convert the provided string parameter: \"" + value + "\"  into a " + Date.class + " instance");
            ill.initCause(e);
            throw ill;
        }
    }

    @Override
    public boolean isParsable(String value) {
        return IpsStringUtils.isEmpty((String)value) || DateUtil.isIsoDate((String)value);
    }

    @Override
    public String valueToString(Object value) {
        if (value == null) {
            return null;
        }
        return formatter.get().format(value);
    }

    public Date getDateValue(String value) {
        return (Date)this.getValue(value);
    }

    @Override
    public boolean supportsCompare() {
        return true;
    }
}

