/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.codegen.dthelpers;

import org.faktorips.codegen.DatatypeHelper;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.faktorips.values.ObjectUtil;
import org.faktorips.valueset.OrderedValueSet;

public abstract class AbstractDatatypeHelper
implements DatatypeHelper {
    private Datatype datatype;

    public AbstractDatatypeHelper() {
    }

    public AbstractDatatypeHelper(Datatype datatype) {
        ArgumentCheck.notNull((Object)datatype);
        this.datatype = datatype;
    }

    @Override
    public Datatype getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(Datatype datatype) {
        this.datatype = datatype;
    }

    protected abstract JavaCodeFragment valueOfExpression(String var1);

    @Override
    public JavaCodeFragment newInstanceFromExpression(String expression) {
        return this.newInstanceFromExpression(expression, true);
    }

    @Override
    public JavaCodeFragment newInstanceFromExpression(String expression, boolean checkForNull) {
        if (expression == null || expression.length() == 0) {
            return this.nullExpression();
        }
        Object resultingExpression = expression;
        if (((String)resultingExpression).startsWith("(")) {
            resultingExpression = "(" + (String)resultingExpression + ")";
        }
        if (!checkForNull) {
            return this.valueOfExpression((String)resultingExpression);
        }
        return this.generateNewInstanceWithStringUtils((String)resultingExpression);
    }

    private JavaCodeFragment generateNewInstanceWithStringUtils(String expression) {
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.appendClassName(IpsStringUtils.class).append(".isEmpty(").append(expression).append(") ? ");
        fragment.append(this.nullExpression());
        fragment.append(" : ");
        fragment.append(this.valueOfExpression(expression));
        return fragment;
    }

    @Override
    public String getRangeJavaClassName(boolean useTypesafeCollections) {
        return null;
    }

    @Override
    public JavaCodeFragment newRangeInstance(JavaCodeFragment lowerBoundExp, JavaCodeFragment upperBoundExp, JavaCodeFragment stepExp, JavaCodeFragment containsNullExp, boolean useTypesafeCollections) {
        return null;
    }

    @Override
    public JavaCodeFragment newEnumValueSetInstance(String[] values, boolean containsNull, boolean useTypesafeCollections) {
        JavaCodeFragment frag = new JavaCodeFragment();
        frag.append("new ");
        frag.appendClassName(OrderedValueSet.class);
        frag.append("<>(");
        frag.append(containsNull);
        frag.append(", ");
        frag.append(this.newValueInstance(null));
        for (String value : values) {
            frag.append(", ");
            if (values.length == 1 && null == value) {
                frag.append(this.createCastExpression(value));
                continue;
            }
            frag.append(this.newValueInstance(value));
        }
        frag.appendln(")");
        return frag;
    }

    @Override
    public JavaCodeFragment newEnumValueSetInstance(JavaCodeFragment valueCollection, JavaCodeFragment containsNullExpression, boolean useTypesafeCollections) {
        JavaCodeFragment frag = new JavaCodeFragment();
        frag.append("new ");
        frag.appendClassName(OrderedValueSet.class);
        frag.append("<>");
        frag.append("(");
        frag.append(valueCollection);
        frag.append(", ");
        frag.append(containsNullExpression);
        frag.append(", ");
        frag.append(this.nullExpression());
        frag.appendln(")");
        return frag;
    }

    @Override
    public JavaCodeFragment referenceOrSafeCopyIfNeccessary(String expression) {
        if (this.datatype.isValueDatatype() && ((ValueDatatype)this.datatype).isMutable()) {
            return this.newSafeCopy(expression);
        }
        return new JavaCodeFragment(expression);
    }

    protected JavaCodeFragment newSafeCopy(String expression) {
        throw new RuntimeException("The DatatypeHelper for datatype " + this.datatype + " does not override the method newSafeCopy!");
    }

    @Override
    public JavaCodeFragment getToStringExpression(String fieldName) {
        return new JavaCodeFragment().appendClassName(ObjectUtil.class).append(".isNull(").append(fieldName).append(")").append(" ? null : ").append(fieldName).append(".toString()");
    }

    @Override
    public JavaCodeFragment nullExpression() {
        return new JavaCodeFragment("null");
    }

    @Override
    public JavaCodeFragment createCastExpression(String bound) {
        JavaCodeFragment frag = new JavaCodeFragment();
        if (IpsStringUtils.isEmpty((String)bound) && !this.getDatatype().hasNullObject()) {
            frag.append('(');
            frag.appendClassName(this.getJavaClassName());
            frag.append(')');
        }
        frag.append(this.newValueInstance(bound));
        return frag;
    }
}

