/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.datatype.classtypes;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.faktorips.datatype.NumericDatatype;
import org.faktorips.datatype.ValueClassNameDatatype;
import org.faktorips.runtime.internal.IpsStringUtils;

public class BigDecimalDatatype
extends ValueClassNameDatatype
implements NumericDatatype {
    public BigDecimalDatatype() {
        super(BigDecimal.class.getSimpleName());
    }

    @Override
    public Object getValue(String value) {
        if (IpsStringUtils.isEmpty((String)value)) {
            return null;
        }
        return new BigDecimal(value);
    }

    @Override
    public boolean supportsCompare() {
        return true;
    }

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    public boolean divisibleWithoutRemainder(String dividend, String divisor) {
        if (dividend == null || divisor == null) {
            throw new NullPointerException("dividend and divisor both can not be null.");
        }
        BigDecimal a = (BigDecimal)this.getValue(dividend);
        BigDecimal b = (BigDecimal)this.getValue(divisor);
        try {
            a.divide(b, 0, RoundingMode.UNNECESSARY);
        }
        catch (ArithmeticException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean hasDecimalPlaces() {
        return true;
    }

    @Override
    public String subtract(String minuend, String subtrahend) {
        if (minuend == null || subtrahend == null) {
            throw new NullPointerException("Minuend and subtrahend both can not be null.");
        }
        return ((BigDecimal)this.getValue(minuend)).subtract((BigDecimal)this.getValue(subtrahend)).toString();
    }
}

