/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.codegen.dthelpers.java8;

import java.time.format.DateTimeFormatter;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.codegen.dthelpers.AbstractTimeHelper;
import org.faktorips.codegen.dthelpers.java8.ParseHelper;
import org.faktorips.datatype.joda.LocalDateTimeDatatype;
import org.faktorips.values.ObjectUtil;

public class LocalDateTimeHelper
extends AbstractTimeHelper {
    private static final String JAVA_TIME_LOCAL_DATE_TIME = "java.time.LocalDateTime";

    public LocalDateTimeHelper(LocalDateTimeDatatype datatype) {
        super(datatype);
    }

    @Override
    protected JavaCodeFragment valueOfExpression(String expression) {
        return ParseHelper.parse(expression, JAVA_TIME_LOCAL_DATE_TIME);
    }

    @Override
    public String getJavaClassName() {
        return JAVA_TIME_LOCAL_DATE_TIME;
    }

    @Override
    public JavaCodeFragment getToStringExpression(String fieldName) {
        return new JavaCodeFragment().appendClassName(ObjectUtil.class).append(".isNull(").append(fieldName).append(")").append(" ? null : ").append(fieldName).append(".format(").appendClassName(DateTimeFormatter.class).append(".ISO_LOCAL_DATE_TIME)");
    }
}

