/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.datatype;

import org.faktorips.datatype.AbstractPrimitiveDatatype;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.NumericDatatype;
import org.faktorips.datatype.ValueDatatype;

public class PrimitiveLongDatatype
extends AbstractPrimitiveDatatype
implements NumericDatatype {
    @Override
    public String getName() {
        return "long";
    }

    @Override
    public String getQualifiedName() {
        return "long";
    }

    @Override
    public ValueDatatype getWrapperType() {
        return Datatype.LONG;
    }

    @Override
    public String getDefaultValue() {
        return "0";
    }

    @Override
    public Object getValue(String value) {
        return Long.valueOf(value);
    }

    @Override
    public boolean supportsCompare() {
        return true;
    }

    @Override
    public String subtract(String minuend, String subtrahend) {
        if (minuend == null || subtrahend == null) {
            throw new NullPointerException("Minuend and subtrahend both can not be null.");
        }
        long result = (Long)this.getValue(minuend) - (Long)this.getValue(subtrahend);
        return Long.toString(result);
    }

    @Override
    public boolean divisibleWithoutRemainder(String dividend, String divisor) {
        if (dividend == null || divisor == null) {
            throw new NullPointerException("dividend and divisor both can not be null.");
        }
        long a = (Long)this.getValue(dividend);
        long b = (Long)this.getValue(divisor);
        return b == 0L ? false : a % b == 0L;
    }

    @Override
    public boolean hasDecimalPlaces() {
        return false;
    }
}

