/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.codegen.dthelpers;

import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.codegen.dthelpers.AbstractDatatypeHelper;
import org.faktorips.datatype.classtypes.IntegerDatatype;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.valueset.IntegerRange;

public class IntegerHelper
extends AbstractDatatypeHelper {
    public IntegerHelper() {
    }

    public IntegerHelper(IntegerDatatype datatype) {
        super(datatype);
    }

    @Override
    public String getJavaClassName() {
        return Integer.class.getName();
    }

    @Override
    public JavaCodeFragment newInstance(String value) {
        if (IpsStringUtils.isEmpty((String)value)) {
            return this.nullExpression();
        }
        String trimmedValue = value.trim();
        if (trimmedValue.charAt(0) != '0') {
            return this.valueOfExpression(trimmedValue);
        }
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.appendClassName(Integer.class);
        fragment.append(".valueOf(");
        fragment.appendQuoted(trimmedValue);
        fragment.append(')');
        return fragment;
    }

    @Override
    protected JavaCodeFragment valueOfExpression(String expression) {
        if (IpsStringUtils.isEmpty((String)expression)) {
            return this.nullExpression();
        }
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.appendClassName(Integer.class);
        fragment.append(".valueOf(");
        fragment.append(expression);
        fragment.append(')');
        return fragment;
    }

    @Override
    public String getRangeJavaClassName(boolean useTypesafeCollections) {
        return IntegerRange.class.getName();
    }

    @Override
    public JavaCodeFragment newRangeInstance(JavaCodeFragment lowerBoundExp, JavaCodeFragment upperBoundExp, JavaCodeFragment stepExp, JavaCodeFragment containsNullExp, boolean useTypesafeCollections) {
        JavaCodeFragment frag = new JavaCodeFragment();
        frag.appendClassName(this.getRangeJavaClassName(useTypesafeCollections));
        frag.append(".valueOf(");
        frag.append(lowerBoundExp);
        frag.append(", ");
        frag.append(upperBoundExp);
        frag.append(", ");
        frag.append(stepExp);
        frag.append(", ");
        frag.append(containsNullExp);
        frag.append(")");
        return frag;
    }
}

