/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.codegen;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.runtime.internal.IpsStringUtils;

public class JavaCodeFragmentBuilder {
    private JavaCodeFragment fragment;
    private int lastMethodModifier;

    public JavaCodeFragmentBuilder() {
        this(false);
    }

    public JavaCodeFragmentBuilder(boolean indent) {
        this.fragment = new JavaCodeFragment(indent);
    }

    public JavaCodeFragment getFragment() {
        return this.fragment;
    }

    public JavaCodeFragmentBuilder addImport(String qualifiedClassName) {
        this.fragment.addImport(qualifiedClassName);
        return this;
    }

    public JavaCodeFragmentBuilder addImport(Class<?> clazz) {
        this.fragment.addImport(clazz.getName());
        return this;
    }

    public JavaCodeFragmentBuilder appendln() {
        this.fragment.appendln();
        return this;
    }

    public JavaCodeFragmentBuilder append(String s) {
        this.fragment.append(s);
        return this;
    }

    public JavaCodeFragmentBuilder appendQuoted(String s) {
        this.fragment.appendQuoted(s);
        return this;
    }

    public JavaCodeFragmentBuilder append(char c) {
        this.fragment.append(c);
        return this;
    }

    public JavaCodeFragmentBuilder append(int i) {
        this.fragment.append(i);
        return this;
    }

    public JavaCodeFragmentBuilder appendClassName(Class<?> clazz) {
        this.fragment.appendClassName(clazz);
        return this;
    }

    public JavaCodeFragmentBuilder appendClassName(String qualifiedClassName) {
        this.fragment.appendClassName(qualifiedClassName);
        return this;
    }

    public JavaCodeFragmentBuilder appendln(String s) {
        this.fragment.appendln(s);
        return this;
    }

    public JavaCodeFragmentBuilder appendln(char c) {
        this.fragment.appendln(c);
        return this;
    }

    public JavaCodeFragmentBuilder append(JavaCodeFragment fragment) {
        this.fragment.append(fragment);
        return this;
    }

    public JavaCodeFragmentBuilder appendJavaModifier(int modifier) {
        this.append(Modifier.toString(modifier));
        return this;
    }

    public JavaCodeFragmentBuilder openBracket() {
        if (!this.fragment.bol()) {
            this.fragment.appendln();
        }
        this.fragment.appendln('{');
        this.fragment.incIndentationLevel();
        return this;
    }

    public JavaCodeFragmentBuilder closeBracket() {
        this.fragment.decIndentationLevel();
        if (!this.fragment.bol()) {
            this.fragment.appendln();
        }
        this.fragment.appendln('}');
        return this;
    }

    public JavaCodeFragmentBuilder method(int modifier, String returnType, String methodName, String[] argName, String[] argClass, JavaCodeFragment body, String javadoc) {
        this.javaDoc(javadoc, new String[0]);
        this.methodBegin(modifier, returnType, methodName, argName, argClass);
        this.append(body);
        this.methodEnd();
        return this;
    }

    public JavaCodeFragmentBuilder methodBegin(int modifier, Class<?> returnType, String methodName, String[] argName, Class<?>[] argClass) {
        this.methodBegin(modifier, returnType, methodName, argName, argClass, null);
        return this;
    }

    public JavaCodeFragmentBuilder methodBegin(int modifier, Class<?> returnType, String methodName, String[] argName, Class<?>[] argClass, Class<?>[] exceptionClasses) {
        this.signatureInternal(modifier, methodName, new ClassAsParameterTypeSupport(argName, argClass, exceptionClasses, returnType), false);
        if (!Modifier.isAbstract(modifier)) {
            this.openBracket();
        }
        return this;
    }

    public JavaCodeFragmentBuilder method(int modifier, Class<?> returnType, String methodName, String[] argName, Class<?>[] argClass, JavaCodeFragment body, String javadoc) {
        this.javaDoc(javadoc, new String[0]);
        this.methodBegin(modifier, returnType, methodName, argName, argClass);
        this.append(body);
        this.methodEnd();
        return this;
    }

    public JavaCodeFragmentBuilder method(int modifier, Class<?> returnType, String methodName, String[] argName, Class<?>[] argClass, Class<?>[] exceptionClasses, JavaCodeFragment body, String javadoc) {
        this.javaDoc(javadoc, new String[0]);
        this.methodBegin(modifier, returnType, methodName, argName, argClass, exceptionClasses);
        this.append(body);
        this.methodEnd();
        return this;
    }

    public JavaCodeFragmentBuilder method(int modifier, Class<?> returnType, String methodName, String[] argName, Class<?>[] argClass, JavaCodeFragment body, String javadoc, String ... javaDocAnnotations) {
        this.javaDoc(javadoc, javaDocAnnotations);
        this.methodBegin(modifier, returnType, methodName, argName, argClass);
        this.append(body);
        this.methodEnd();
        return this;
    }

    public JavaCodeFragmentBuilder method(int modifier, Class<?> returnType, String methodName, String[] argName, Class<?>[] argClass, JavaCodeFragment body, String javadoc, String[] javaDocAnnotations, String[] annotations) {
        this.javaDoc(javadoc, javaDocAnnotations);
        this.annotation(annotations);
        this.methodBegin(modifier, returnType, methodName, argName, argClass);
        this.append(body);
        this.methodEnd();
        return this;
    }

    public JavaCodeFragmentBuilder method(int modifier, String returnType, String methodName, String[] argName, String[] argClass, JavaCodeFragment body, String javadoc, String ... javaDocAnnotations) {
        this.javaDoc(javadoc, javaDocAnnotations);
        this.methodBegin(modifier, returnType, methodName, argName, argClass);
        this.append(body);
        this.methodEnd();
        return this;
    }

    public JavaCodeFragmentBuilder method(int modifier, String returnType, String methodName, String[] argName, String[] argClass, JavaCodeFragment body, String javadoc, String[] javaDocAnnotations, String[] annotations) {
        this.javaDoc(javadoc, javaDocAnnotations);
        this.annotation(annotations);
        this.methodBegin(modifier, returnType, methodName, argName, argClass);
        this.append(body);
        this.methodEnd();
        return this;
    }

    public JavaCodeFragmentBuilder methodBegin(int modifier, String returnType, String methodName, String[] argName, String[] argClass, String javaDoc) {
        this.javaDoc(javaDoc, new String[0]);
        this.methodBegin(modifier, returnType, methodName, argName, argClass);
        return this;
    }

    public JavaCodeFragmentBuilder methodBegin(int modifier, String returnType, String methodName, String[] argName, String[] argClass, String javaDoc, String[] javaDocAnnotations) {
        this.javaDoc(javaDoc, javaDocAnnotations);
        this.methodBegin(modifier, returnType, methodName, argName, argClass);
        return this;
    }

    public JavaCodeFragmentBuilder methodBegin(int modifier, Class<?> returnType, String methodName, String[] argName, Class<?>[] argClass, String javaDoc, String[] javaDocAnnotations) {
        this.javaDoc(javaDoc, javaDocAnnotations);
        this.methodBegin(modifier, returnType, methodName, argName, argClass);
        return this;
    }

    public JavaCodeFragmentBuilder methodBegin(int modifier, String returnType, String methodName, String[] argName, String[] argClass) {
        this.signature(modifier, returnType, methodName, argName, argClass);
        if (!Modifier.isAbstract(modifier)) {
            this.openBracket();
        }
        return this;
    }

    public JavaCodeFragmentBuilder methodBegin(int modifier, String returnType, String methodName, String[] argName, String[] argClass, String[] exceptionClasses) {
        this.signature(modifier, returnType, methodName, argName, argClass, exceptionClasses);
        if (!Modifier.isAbstract(modifier)) {
            this.openBracket();
        }
        return this;
    }

    public JavaCodeFragmentBuilder signature(int modifier, String returnType, String methodName, String[] argName, String[] argClass) {
        this.signature(modifier, returnType, methodName, argName, argClass, false);
        return this;
    }

    public JavaCodeFragmentBuilder signature(int modifier, JavaCodeFragment returnType, String methodName, String[] argName, String[] argClass) {
        this.signatureInternal(modifier, methodName, new StringAsParameterTypeSupport(argName, argClass, null, returnType), false);
        return this;
    }

    public JavaCodeFragmentBuilder signature(int modifier, String returnType, String methodName, String[] argName, String[] argClass, boolean argFinal) {
        JavaCodeFragment returnCode = null;
        if (returnType != null) {
            returnCode = new JavaCodeFragment();
            returnCode.appendClassName(returnType);
        }
        this.signatureInternal(modifier, methodName, new StringAsParameterTypeSupport(argName, argClass, null, returnCode), argFinal);
        return this;
    }

    private JavaCodeFragmentBuilder signatureInternal(int modifier, String methodName, MethodSignatureTypesSupport support, boolean argFinal) {
        int i;
        this.lastMethodModifier = modifier;
        this.append(Modifier.toString(modifier));
        this.append(' ');
        if (support.hasReturnType()) {
            support.appendReturnType();
            this.append(' ');
        }
        this.append(methodName);
        this.append('(');
        for (i = 0; i < support.getNumberOfParameters(); ++i) {
            if (i > 0) {
                this.append(", ");
            }
            if (argFinal) {
                this.append("final ");
            }
            support.appendParameterType(i);
            this.append(' ');
            support.appendParameterName(i);
        }
        this.append(')');
        if (support.getNumberOfExceptionExtensions() == 0) {
            return this;
        }
        this.append(" throws ");
        int max = support.getNumberOfExceptionExtensions();
        for (i = 0; i < max; ++i) {
            if (i > 0) {
                this.append(", ");
            }
            support.appendExceptionExtension(i);
        }
        return this;
    }

    public JavaCodeFragmentBuilder signature(int modifier, String returnType, String methodName, String[] argName, String[] argClass, String[] exceptionClasses) {
        JavaCodeFragment returnCode = null;
        if (returnType != null) {
            returnCode = new JavaCodeFragment();
            returnCode.appendClassName(returnType);
        }
        this.signatureInternal(modifier, methodName, new StringAsParameterTypeSupport(argName, argClass, exceptionClasses, returnCode), false);
        return this;
    }

    public JavaCodeFragmentBuilder signature(int modifier, JavaCodeFragment returnType, String methodName, String[] argName, String[] argClass, String[] exceptionClasses) {
        this.signatureInternal(modifier, methodName, new StringAsParameterTypeSupport(argName, argClass, exceptionClasses, returnType), false);
        return this;
    }

    public JavaCodeFragmentBuilder signature(int modifier, String returnType, String methodName, String[] argName, String[] argClass, String javaDoc, String[] javaDocAnnotations) {
        this.javaDoc(javaDoc, javaDocAnnotations);
        this.signature(modifier, returnType, methodName, argName, argClass);
        return this;
    }

    public JavaCodeFragmentBuilder methodEnd() {
        if (Modifier.isAbstract(this.lastMethodModifier)) {
            this.fragment.appendln(";");
        } else {
            this.closeBracket();
        }
        this.fragment.appendln();
        return this;
    }

    public JavaCodeFragmentBuilder classBegin(int modifier, String className) {
        this.classBegin(modifier, className, (String)null, null);
        return this;
    }

    public JavaCodeFragmentBuilder classBegin(int modifier, String className, Class<?> extendsClass, Class<?>[] interfaces) {
        String extendsClassString;
        String string = extendsClassString = extendsClass == null ? null : extendsClass.getName();
        if (interfaces == null) {
            this.classBegin(modifier, className, extendsClassString, null);
            return this;
        }
        String[] interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = interfaces[i].getName();
        }
        this.classBegin(modifier, className, extendsClassString, interfaceNames);
        return this;
    }

    public JavaCodeFragmentBuilder classBegin(int modifier, String className, String extendsClassName, String[] interfaces) {
        this.fragment.append(Modifier.toString(modifier));
        this.fragment.append(" class ");
        this.fragment.append(className);
        if (extendsClassName != null) {
            this.fragment.append(" extends ");
            this.fragment.appendClassName(extendsClassName);
        }
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                if (i == 0) {
                    this.fragment.append(" implements ");
                } else {
                    this.fragment.append(", ");
                }
                this.fragment.appendClassName(interfaces[i]);
            }
        }
        this.fragment.appendln();
        this.openBracket();
        this.fragment.appendln();
        return this;
    }

    public JavaCodeFragmentBuilder enumBegin(int modifier, String className, String extendsClassName, String[] interfaces) {
        this.fragment.append(Modifier.toString(modifier));
        this.fragment.append(" enum ");
        this.fragment.append(className);
        if (extendsClassName != null) {
            this.fragment.append(" extends ");
            this.fragment.appendClassName(extendsClassName);
        }
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                if (i == 0) {
                    this.fragment.append(" implements ");
                } else {
                    this.fragment.append(", ");
                }
                this.fragment.appendClassName(interfaces[i]);
            }
        }
        this.fragment.appendln();
        this.openBracket();
        this.fragment.appendln();
        return this;
    }

    public JavaCodeFragmentBuilder classEnd() {
        this.closeBracket();
        return this;
    }

    public JavaCodeFragmentBuilder interfaceBegin(String interfaceName) {
        this.interfaceBegin(interfaceName, "");
        return this;
    }

    public JavaCodeFragmentBuilder interfaceBegin(String interfaceName, String extendsInterfaceName) {
        this.fragment.append("public interface ");
        this.fragment.append(interfaceName);
        if (IpsStringUtils.isNotEmpty((String)extendsInterfaceName)) {
            this.fragment.append(" extends ");
            this.fragment.appendClassName(extendsInterfaceName);
        }
        this.fragment.appendln();
        this.openBracket();
        return this;
    }

    public JavaCodeFragmentBuilder interfaceBegin(String interfaceName, String[] extendedInterfaces) {
        this.fragment.append("public interface ");
        this.fragment.append(interfaceName);
        if (extendedInterfaces != null && extendedInterfaces.length > 0) {
            this.fragment.append(" extends ");
            for (int i = 0; i < extendedInterfaces.length; ++i) {
                if (i > 0) {
                    this.fragment.append(", ");
                }
                this.fragment.appendClassName(extendedInterfaces[i]);
            }
        }
        this.fragment.appendln();
        this.openBracket();
        return this;
    }

    public JavaCodeFragmentBuilder varDeclaration(int modifier, Class<?> clazz, String varName) {
        this.varDeclaration(modifier, clazz.getName(), varName);
        return this;
    }

    public JavaCodeFragmentBuilder varDeclaration(int modifier, Class<?> clazz, String varName, JavaCodeFragment expression) {
        this.varDeclaration(modifier, clazz.getName(), varName, expression);
        return this;
    }

    public JavaCodeFragmentBuilder varDeclaration(int modifier, String className, String varName, JavaCodeFragment expression) {
        JavaCodeFragment code = new JavaCodeFragment();
        code.appendClassName(className);
        return this.varDeclaration(modifier, code, varName, expression);
    }

    public JavaCodeFragmentBuilder varDeclaration(int modifier, JavaCodeFragment className, String varName, JavaCodeFragment expression) {
        if (modifier > 0) {
            this.fragment.append(Modifier.toString(modifier));
            this.fragment.append(' ');
        }
        if (className != null) {
            this.append(className);
            this.append(' ');
        }
        this.fragment.append(varName);
        if (expression != null) {
            this.fragment.append(" = ");
            this.fragment.append(expression);
        }
        this.fragment.appendln(";");
        return this;
    }

    public JavaCodeFragmentBuilder varDeclaration(int modifier, String className, String varName) {
        this.varDeclaration(modifier, className, varName, null);
        return this;
    }

    public JavaCodeFragmentBuilder varDefinition(Class<?> varClass, String varName, String varValue) {
        this.varDefinition(varClass.getName(), varName, varValue);
        return this;
    }

    public JavaCodeFragmentBuilder varDefinition(String classOrTypeName, String variableName, String variableValue) {
        this.fragment.append(classOrTypeName);
        this.fragment.append(' ');
        this.assignment(variableName, variableValue);
        return this;
    }

    public JavaCodeFragmentBuilder assignment(String variable, JavaCodeFragment expression) {
        this.fragment.append(variable);
        this.fragment.append(" = ");
        this.fragment.append(expression);
        this.fragment.appendln(";");
        return this;
    }

    public JavaCodeFragmentBuilder assignment(String variable, String value) {
        this.fragment.append(variable);
        this.fragment.append(" = ");
        this.fragment.append(value);
        this.fragment.appendln(";");
        return this;
    }

    public JavaCodeFragmentBuilder singleLineComment(String comment) {
        this.fragment.append("// ");
        if (comment != null) {
            this.fragment.appendln(comment);
        }
        return this;
    }

    public JavaCodeFragmentBuilder multiLineComment(String comment) {
        this.fragment.appendln("/*");
        if (comment != null) {
            this.fragment.appendln("   ");
            this.fragment.appendln(comment);
        }
        this.fragment.appendln("*/");
        return this;
    }

    public JavaCodeFragmentBuilder javaDoc(String text, String ... annotations) {
        if (text == null && annotations == null) {
            return this;
        }
        this.fragment.appendln("/**");
        if (IpsStringUtils.isNotEmpty((String)text)) {
            text.lines().forEach(line -> {
                this.fragment.append(" * ");
                this.fragment.appendln((String)line);
            });
        }
        if (annotations != null) {
            if (IpsStringUtils.isNotEmpty((String)text)) {
                this.fragment.appendln(" *");
            }
            for (String annotation : annotations) {
                this.fragment.append(" * @");
                this.fragment.appendln(annotation);
            }
        }
        this.fragment.appendln(" */");
        return this;
    }

    public JavaCodeFragmentBuilder annotationLn(Class<?> ... annotations) {
        if (annotations == null) {
            return this;
        }
        for (Class<?> annotation : annotations) {
            this.fragment.append("@");
            this.fragment.appendClassName(annotation);
            this.fragment.appendln();
        }
        return this;
    }

    public JavaCodeFragmentBuilder annotationLn(Class<?> annotation, String params) {
        JavaCodeFragment paramsCodeFragment = new JavaCodeFragment();
        if (IpsStringUtils.isNotEmpty((String)params)) {
            paramsCodeFragment.append(params);
        }
        return this.annotationLn(annotation, paramsCodeFragment);
    }

    public JavaCodeFragmentBuilder annotationLn(Class<?> annotation, JavaCodeFragment params) {
        this.annotation(annotation.getName(), params).appendln();
        return this;
    }

    public JavaCodeFragmentBuilder annotation(Class<?> annotation, JavaCodeFragment params) {
        if (annotation == null) {
            return this;
        }
        this.annotation(annotation.getName(), params);
        return this;
    }

    public JavaCodeFragmentBuilder annotationLn(Class<?> annotation, String paramName, String stringValue) {
        if (annotation == null) {
            return this;
        }
        this.annotationLn(annotation.getName(), paramName, stringValue);
        return this;
    }

    public JavaCodeFragmentBuilder annotationLn(String annotation, JavaCodeFragment params) {
        return this.annotation(annotation, params).appendln();
    }

    public JavaCodeFragmentBuilder annotation(String annotation, JavaCodeFragment params) {
        if (annotation == null) {
            return this;
        }
        this.fragment.append("@");
        this.fragment.appendClassName(annotation);
        if (params != null && params.getSourcecode().length() > 0) {
            this.fragment.append('(');
            this.fragment.append(params);
            this.fragment.append(')');
        }
        return this;
    }

    public JavaCodeFragmentBuilder annotationLn(String annotation, String params) {
        JavaCodeFragment paramsCodeFragment = new JavaCodeFragment();
        if (IpsStringUtils.isNotEmpty((String)params)) {
            paramsCodeFragment.append(params);
        }
        return this.annotationLn(annotation, paramsCodeFragment);
    }

    public JavaCodeFragmentBuilder annotationLn(String annotation, String paramName, String stringValue) {
        if (annotation == null) {
            return this;
        }
        this.annotation(annotation, paramName, stringValue);
        this.fragment.appendln();
        return this;
    }

    public JavaCodeFragmentBuilder annotation(String annotation, String paramName, String stringValue) {
        if (annotation == null) {
            return this;
        }
        this.fragment.append("@");
        this.fragment.appendClassName(annotation);
        this.fragment.append('(');
        this.fragment.append(paramName);
        this.fragment.append('=');
        this.fragment.appendQuoted(stringValue);
        this.fragment.append(')');
        return this;
    }

    public JavaCodeFragmentBuilder annotationClassValueLn(String annotation, String paramName, String qualifiedClassName) {
        if (annotation == null) {
            return this;
        }
        this.fragment.append("@");
        this.fragment.appendClassName(annotation);
        this.fragment.append('(');
        this.fragment.append(paramName);
        this.fragment.append('=');
        this.fragment.appendClassName(qualifiedClassName);
        this.fragment.append(".class");
        this.fragment.append(')');
        this.fragment.appendln();
        return this;
    }

    public JavaCodeFragmentBuilder annotation(String[] annotations) {
        if (annotations == null) {
            return this;
        }
        for (String annotation : annotations) {
            this.annotationLn(annotation);
        }
        return this;
    }

    public JavaCodeFragmentBuilder annotationLn(String annotation) {
        if (annotation == null) {
            return this;
        }
        this.fragment.append("@");
        int index = annotation.indexOf(40);
        if (index == -1) {
            this.fragment.appendClassName(annotation);
            this.fragment.appendln();
            return this;
        }
        this.fragment.appendClassName(annotation.substring(0, index));
        this.fragment.appendln(annotation.substring(index));
        return this;
    }

    public JavaCodeFragmentBuilder methodCall(String name, String[] parameters, boolean finishLine) {
        this.fragment.append(name);
        this.appendParameters(parameters);
        if (finishLine) {
            this.fragment.appendln(';');
        }
        return this;
    }

    public JavaCodeFragmentBuilder methodCall(String name, JavaCodeFragment[] parameterFragments, boolean finishLine) {
        this.fragment.append(name);
        this.appendParameters(parameterFragments);
        if (finishLine) {
            this.fragment.appendln(';');
        }
        return this;
    }

    public JavaCodeFragmentBuilder methodCall(String name, List<String> parameters, boolean finishLine) {
        return this.methodCall(name, parameters.toArray(new String[parameters.size()]), finishLine);
    }

    public JavaCodeFragmentBuilder constructorCall(String className, String[] parameters, boolean finishLine) {
        this.append("new ");
        this.appendClassName(className);
        this.appendParameters(parameters);
        if (finishLine) {
            this.fragment.appendln(';');
        }
        return this;
    }

    public JavaCodeFragmentBuilder constructorCall(String className, List<String> parameters, boolean finishLine) {
        return this.constructorCall(className, parameters.toArray(new String[parameters.size()]), finishLine);
    }

    public JavaCodeFragmentBuilder appendParameters(String[] parameters) {
        JavaCodeFragment[] jcfParams = new JavaCodeFragment[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            jcfParams[i] = new JavaCodeFragment(parameters[i]);
        }
        this.appendParameters(jcfParams);
        return this;
    }

    public JavaCodeFragmentBuilder appendParameters(JavaCodeFragment[] parameters) {
        this.append('(');
        this.fragment.appendJoined(parameters);
        this.append(')');
        return this;
    }

    public JavaCodeFragmentBuilder appendGenerics(String ... classNames) {
        if (classNames.length > 0) {
            this.append('<');
            for (String className : classNames) {
                this.appendClassName(className);
                if (className.equals(classNames[classNames.length - 1])) continue;
                this.append(", ");
            }
            this.append('>');
        }
        return this;
    }

    public JavaCodeFragmentBuilder appendGenerics(Class<?> ... classes) {
        if (classes.length > 0) {
            this.append('<');
            int i = 1;
            for (Class<?> clazz : classes) {
                this.appendClassName(clazz);
                if (i >= classes.length) continue;
                this.append(", ");
                ++i;
            }
            this.append('>');
        }
        return this;
    }

    public JavaCodeFragmentBuilder appendJoin(List<JavaCodeFragment> parts, String separator) {
        if (parts == null) {
            return this;
        }
        String nullSafeSeparator = Objects.toString(separator, "");
        for (int i = 0; i < parts.size(); ++i) {
            this.append(parts.get(i));
            if (i + 1 >= parts.size()) continue;
            this.append(nullSafeSeparator);
        }
        return this;
    }

    public String toString() {
        return this.fragment.toString();
    }

    private class ClassAsParameterTypeSupport
    extends MethodSignatureTypesSupport {
        private String[] parameterNames = null;
        private Class<?>[] parameterTypes = null;
        private Class<?> returnType = null;
        private Class<?>[] exceptionClasses = null;

        public ClassAsParameterTypeSupport(String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] exceptionClasses, Class<?> returnType) {
            this.check(parameterNames, parameterTypes);
            this.parameterNames = parameterNames;
            this.parameterTypes = parameterTypes;
            this.exceptionClasses = exceptionClasses;
            this.returnType = returnType;
        }

        @Override
        public void appendParameterName(int index) {
            JavaCodeFragmentBuilder.this.append(this.parameterNames[index]);
        }

        @Override
        public void appendParameterType(int index) {
            JavaCodeFragmentBuilder.this.appendClassName(this.parameterTypes[index]);
        }

        @Override
        public void appendReturnType() {
            JavaCodeFragmentBuilder.this.appendClassName(this.returnType);
        }

        @Override
        public int getNumberOfParameters() {
            return this.parameterNames == null ? 0 : this.parameterNames.length;
        }

        @Override
        public boolean hasReturnType() {
            return this.returnType != null;
        }

        @Override
        public void appendExceptionExtension(int index) {
            JavaCodeFragmentBuilder.this.appendClassName(this.exceptionClasses[index]);
        }

        @Override
        public int getNumberOfExceptionExtensions() {
            return this.exceptionClasses == null ? 0 : this.exceptionClasses.length;
        }
    }

    private static abstract class MethodSignatureTypesSupport {
        private MethodSignatureTypesSupport() {
        }

        protected void check(String[] parameterNames, Object[] parameterTypes) {
            if (parameterNames != null && parameterNames.length != parameterTypes.length) {
                throw new RuntimeException("Named and Class array must have the same length");
            }
        }

        public abstract boolean hasReturnType();

        public abstract void appendReturnType();

        public abstract int getNumberOfParameters();

        public abstract void appendParameterName(int var1);

        public abstract void appendParameterType(int var1);

        public abstract void appendExceptionExtension(int var1);

        public abstract int getNumberOfExceptionExtensions();
    }

    private class StringAsParameterTypeSupport
    extends MethodSignatureTypesSupport {
        private String[] parameterNames = null;
        private String[] parameterTypes = null;
        private String[] exceptionClasses = null;
        private JavaCodeFragment returnType = null;

        public StringAsParameterTypeSupport(String[] parameterNames, String[] parameterTypes, String[] exceptionClasses, JavaCodeFragment returnType) {
            this.check(parameterNames, parameterTypes);
            this.parameterNames = parameterNames;
            this.parameterTypes = parameterTypes;
            this.exceptionClasses = exceptionClasses;
            this.returnType = returnType;
        }

        @Override
        public void appendParameterName(int index) {
            JavaCodeFragmentBuilder.this.append(this.parameterNames[index]);
        }

        @Override
        public void appendParameterType(int index) {
            JavaCodeFragmentBuilder.this.appendClassName(this.parameterTypes[index]);
        }

        @Override
        public void appendReturnType() {
            JavaCodeFragmentBuilder.this.append(this.returnType);
        }

        @Override
        public int getNumberOfParameters() {
            return this.parameterNames == null ? 0 : this.parameterNames.length;
        }

        @Override
        public boolean hasReturnType() {
            return this.returnType != null;
        }

        @Override
        public void appendExceptionExtension(int index) {
            JavaCodeFragmentBuilder.this.appendClassName(this.exceptionClasses[index]);
        }

        @Override
        public int getNumberOfExceptionExtensions() {
            return this.exceptionClasses == null ? 0 : this.exceptionClasses.length;
        }
    }
}

