/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.datatype;

import java.util.Objects;
import org.faktorips.datatype.AbstractDatatype;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.util.ArgumentCheck;

public class ArrayOfValueDatatype
extends AbstractDatatype
implements ValueDatatype {
    private Datatype datatype;
    private int dimension;

    public ArrayOfValueDatatype(Datatype datatype, int dimension) {
        ArgumentCheck.notNull((Object)datatype);
        this.datatype = datatype;
        this.dimension = dimension;
    }

    public static final int getDimension(String datatypeName) {
        if (datatypeName == null) {
            return 0;
        }
        int dimension = 0;
        String datatypeNameTemp = datatypeName;
        while (datatypeNameTemp.endsWith("[]")) {
            ++dimension;
            datatypeNameTemp = datatypeNameTemp.substring(0, datatypeNameTemp.length() - 2);
        }
        return dimension;
    }

    public static final String getBasicDatatypeName(String datatypeName) {
        if (datatypeName == null) {
            return null;
        }
        String datatypeNameTemp = datatypeName;
        while (datatypeNameTemp.endsWith("[]")) {
            datatypeNameTemp = datatypeNameTemp.substring(0, datatypeNameTemp.length() - 2);
        }
        return datatypeNameTemp;
    }

    public static final boolean isArrayDatatype(String datatypeName) {
        return ArrayOfValueDatatype.getDimension(datatypeName) != 0;
    }

    public Datatype getBasicDatatype() {
        return this.datatype;
    }

    public int getDimension() {
        return this.dimension;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder(this.datatype.getName());
        for (int i = 0; i < this.dimension; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    @Override
    public String getQualifiedName() {
        StringBuilder sb = new StringBuilder(this.datatype.getQualifiedName());
        for (int i = 0; i < this.dimension; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public String getDefaultValue() {
        return null;
    }

    @Override
    public boolean isValueDatatype() {
        return true;
    }

    @Override
    public ValueDatatype getWrapperType() {
        return null;
    }

    @Override
    public boolean isParsable(String value) {
        return value == null;
    }

    @Override
    public Object getValue(String value) {
        if (value == null) {
            return null;
        }
        throw new RuntimeException("No supported yet.");
    }

    @Override
    public String valueToString(Object value) {
        if (value == null) {
            return null;
        }
        throw new RuntimeException("No supported yet.");
    }

    @Override
    public boolean isNull(String value) {
        return value == null;
    }

    @Override
    public boolean supportsCompare() {
        return this.datatype.isValueDatatype() && ((ValueDatatype)this.datatype).supportsCompare();
    }

    @Override
    public int compare(String valueA, String valueB) {
        if (!this.supportsCompare()) {
            throw new UnsupportedOperationException("The datatype " + this.datatype.getQualifiedName() + " does not support comparison for values.");
        }
        return ((ValueDatatype)this.datatype).compare(valueA, valueB);
    }

    @Override
    public boolean areValuesEqual(String valueA, String valueB) {
        if (this.datatype.isValueDatatype()) {
            return ((ValueDatatype)this.datatype).areValuesEqual(valueA, valueB);
        }
        return Objects.equals(valueA, valueB);
    }
}

