/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.datatype.classtypes;

import java.math.RoundingMode;
import org.faktorips.datatype.NumericDatatype;
import org.faktorips.datatype.ValueClassNameDatatype;
import org.faktorips.values.Decimal;

public class DecimalDatatype
extends ValueClassNameDatatype
implements NumericDatatype {
    public DecimalDatatype() {
        super(Decimal.class.getSimpleName());
    }

    @Override
    public Object getValue(String s) {
        return Decimal.valueOf((String)s);
    }

    @Override
    public boolean hasNullObject() {
        return true;
    }

    @Override
    public boolean supportsCompare() {
        return true;
    }

    @Override
    public String subtract(String minuend, String subtrahend) {
        if (minuend == null || subtrahend == null) {
            throw new NullPointerException("Minuend and subtrahend both can not be null.");
        }
        return ((Decimal)this.getValue(minuend)).subtract((Decimal)this.getValue(subtrahend)).toString();
    }

    @Override
    public boolean divisibleWithoutRemainder(String dividend, String divisor) {
        if (dividend == null || divisor == null) {
            throw new NullPointerException("dividend and divisor both can not be null.");
        }
        Decimal a = Decimal.valueOf((String)dividend);
        Decimal b = Decimal.valueOf((String)divisor);
        try {
            a.divide(b, 0, RoundingMode.UNNECESSARY);
        }
        catch (ArithmeticException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean hasDecimalPlaces() {
        return true;
    }
}

