/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.codegen;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.faktorips.codegen.CodeFragment;
import org.faktorips.codegen.ImportDeclaration;
import org.faktorips.util.StringUtil;

public class JavaCodeFragment
extends CodeFragment {
    private ImportDeclaration importDecl;

    public JavaCodeFragment() {
        this(false);
    }

    public JavaCodeFragment(boolean indent) {
        super(indent);
        this.importDecl = new ImportDeclaration();
    }

    public JavaCodeFragment(String sourcecode) {
        this(sourcecode, new ImportDeclaration());
    }

    public JavaCodeFragment(String sourcecode, ImportDeclaration importDecl) {
        super(sourcecode);
        this.importDecl = new ImportDeclaration(importDecl);
    }

    public JavaCodeFragment(JavaCodeFragment fragment, String packageName) {
        super(fragment);
        this.importDecl = new ImportDeclaration(fragment.importDecl, packageName);
    }

    public JavaCodeFragment(JavaCodeFragment fragment) {
        this(fragment.getSourcecode(), new ImportDeclaration(fragment.getImportDeclaration()));
    }

    public ImportDeclaration getImportDeclaration() {
        return new ImportDeclaration(this.importDecl);
    }

    public ImportDeclaration getImportDeclaration(String packageName) {
        return new ImportDeclaration(this.importDecl, packageName);
    }

    public JavaCodeFragment appendOpenBracket() {
        this.appendln('{');
        this.incIndentationLevel();
        return this;
    }

    public JavaCodeFragment appendCloseBracket() {
        this.appendln('}');
        this.decIndentationLevel();
        return this;
    }

    @Override
    public JavaCodeFragment append(String s) {
        return (JavaCodeFragment)super.append(s);
    }

    @Override
    public JavaCodeFragment appendJoined(Iterable<?> iterable) {
        return (JavaCodeFragment)super.appendJoined(iterable);
    }

    @Override
    public JavaCodeFragment appendJoined(Object[] array) {
        return (JavaCodeFragment)super.appendJoined(array);
    }

    public JavaCodeFragment appendJoined(JavaCodeFragment[] javaCodeFragments) {
        boolean first = true;
        for (JavaCodeFragment javaCodeFragment : javaCodeFragments) {
            if (!first) {
                this.append(", ");
            }
            this.append(javaCodeFragment);
            first = false;
        }
        return this;
    }

    @Override
    public JavaCodeFragment appendQuoted(String s) {
        return (JavaCodeFragment)super.appendQuoted(s);
    }

    @Override
    public JavaCodeFragment append(char c) {
        return (JavaCodeFragment)super.append(c);
    }

    @Override
    public JavaCodeFragment appendln() {
        return (JavaCodeFragment)super.appendln();
    }

    @Override
    public JavaCodeFragment appendln(String s) {
        return (JavaCodeFragment)super.appendln(s);
    }

    @Override
    public JavaCodeFragment appendlnUnindented(String arg) {
        return (JavaCodeFragment)super.appendlnUnindented(arg);
    }

    @Override
    public JavaCodeFragment appendln(char c) {
        return (JavaCodeFragment)super.appendln(c);
    }

    public JavaCodeFragment append(int i) {
        this.append("" + i);
        return this;
    }

    public JavaCodeFragment append(boolean b) {
        this.append("" + b);
        return this;
    }

    public JavaCodeFragment appendClassName(Class<?> clazz) {
        if (clazz.isArray()) {
            this.appendClassName(clazz.getComponentType());
            this.append("[]");
            return this;
        }
        this.appendClassName(clazz.getName());
        return this;
    }

    public JavaCodeFragment appendInnerClassName(Class<?> clazz) {
        this.appendInnerClassName(clazz.getName());
        return this;
    }

    public JavaCodeFragment appendInnerClassName(String qualifiedClassName) {
        this.appendClassName(qualifiedClassName.replace('$', '.'));
        return this;
    }

    public JavaCodeFragment appendClassName(String qualifiedClassName) {
        if (qualifiedClassName.contains("<")) {
            return this.appendClassNameAndParseGenerics(qualifiedClassName);
        }
        return this.appendClassNameWithoutGenerics(qualifiedClassName);
    }

    private JavaCodeFragment appendClassNameAndParseGenerics(String qualifiedClassName) {
        this.appendClassNameWithoutGenerics(qualifiedClassName.substring(0, qualifiedClassName.indexOf(60)));
        this.parseGenerics(qualifiedClassName);
        return this;
    }

    private void parseGenerics(String qualifiedClassName) {
        String generics = qualifiedClassName.substring(qualifiedClassName.indexOf(60) + 1, qualifiedClassName.lastIndexOf(62));
        List<String> toplevelGenericTypes = this.splitToplevelGenericTypesByColon(generics);
        this.append('<');
        Iterator<String> iterator = toplevelGenericTypes.iterator();
        while (iterator.hasNext()) {
            String nextGenericType = iterator.next();
            this.appendClassName(nextGenericType);
            if (!iterator.hasNext()) continue;
            this.append(", ");
        }
        this.append('>');
    }

    List<String> splitToplevelGenericTypesByColon(String genericsDefinition) {
        LinkedList<String> result = new LinkedList<String>();
        int depth = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < genericsDefinition.length(); ++i) {
            char c = genericsDefinition.charAt(i);
            if (c == '<') {
                ++depth;
            } else if (c == '>') {
                --depth;
            } else if (c == ',' && depth == 0) {
                result.add(sb.toString().trim());
                sb = new StringBuilder();
                continue;
            }
            sb.append(c);
        }
        result.add(sb.toString().trim());
        return result;
    }

    private JavaCodeFragment appendClassNameWithoutGenerics(String className) {
        String qualifiedClassName = className.replace('$', '.');
        String unqualifiedClassName = StringUtil.unqualifiedName((String)qualifiedClassName);
        Iterator<String> iterator = this.importDecl.iterator();
        while (iterator.hasNext()) {
            String imp = iterator.next();
            if (!imp.substring(imp.lastIndexOf(46) + 1).equals(unqualifiedClassName) || imp.equals(qualifiedClassName)) continue;
            this.append(qualifiedClassName);
            return this;
        }
        this.append(unqualifiedClassName);
        if (qualifiedClassName.indexOf(46) < 0) {
            return this;
        }
        int bracketIndex = qualifiedClassName.indexOf("[]");
        if (bracketIndex > -1) {
            this.importDecl.add(qualifiedClassName.substring(0, bracketIndex));
        } else {
            this.importDecl.add(qualifiedClassName);
        }
        return this;
    }

    public JavaCodeFragment addImport(String qualifiedClassName) {
        this.importDecl.add(qualifiedClassName);
        return this;
    }

    @Override
    public JavaCodeFragment append(CodeFragment fragment) {
        return this.append((JavaCodeFragment)fragment);
    }

    public JavaCodeFragment append(JavaCodeFragment fragment) {
        this.importDecl.add(fragment.getImportDeclaration());
        super.append(fragment);
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + (this.importDecl == null ? 0 : this.importDecl.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JavaCodeFragment other = (JavaCodeFragment)obj;
        if (!super.equals(obj)) {
            return false;
        }
        return Objects.equals(this.importDecl, other.importDecl);
    }

    @Override
    public String toString() {
        return this.importDecl.toString() + System.lineSeparator() + super.toString();
    }
}

