/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.datatype.classtypes;

import org.faktorips.datatype.NumericDatatype;
import org.faktorips.datatype.ValueClassNameDatatype;
import org.faktorips.runtime.internal.IpsStringUtils;

public class LongDatatype
extends ValueClassNameDatatype
implements NumericDatatype {
    public LongDatatype() {
        super(Long.class.getSimpleName());
    }

    @Override
    public Object getValue(String s) {
        if (IpsStringUtils.isEmpty((String)s)) {
            return null;
        }
        return Long.valueOf(s);
    }

    @Override
    public boolean supportsCompare() {
        return true;
    }

    @Override
    public String subtract(String minuend, String subtrahend) {
        if (minuend == null || subtrahend == null) {
            throw new NullPointerException("Minuend and subtrahend both can not be null.");
        }
        long result = (Long)this.getValue(minuend) - (Long)this.getValue(subtrahend);
        return Long.toString(result);
    }

    @Override
    public boolean divisibleWithoutRemainder(String dividend, String divisor) {
        if (dividend == null || divisor == null) {
            throw new NullPointerException("dividend and divisor both can not be null.");
        }
        Long longA = (Long)this.getValue(dividend);
        Long longB = (Long)this.getValue(divisor);
        if (longA == null) {
            throw new NumberFormatException("The dividend '" + dividend + "' can not be parsed to a Long");
        }
        if (longB == null) {
            throw new NumberFormatException("The divisor '" + divisor + "' can not be parsed to a Long");
        }
        long a = longA;
        long b = longB;
        return b == 0L ? false : a % b == 0L;
    }

    @Override
    public boolean hasDecimalPlaces() {
        return false;
    }
}

