/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.codegen.dthelpers.java8;

import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.codegen.dthelpers.AbstractTimeHelper;
import org.faktorips.codegen.dthelpers.ILocalDateHelper;
import org.faktorips.codegen.dthelpers.java8.ParseHelper;
import org.faktorips.datatype.joda.LocalDateDatatype;

public class LocalDateHelper
extends AbstractTimeHelper
implements ILocalDateHelper {
    private static final String WEEKS = "WEEKS";
    private static final String YEAR = "YEAR";
    private static final String MONTH_OF_YEAR = "MONTH_OF_YEAR";
    private static final String DAY_OF_MONTH = "DAY_OF_MONTH";
    private static final String JAVA_TIME_TEMPORAL_CHRONO_FIELD = "java.time.temporal.ChronoField";
    private static final String JAVA_TIME_TEMPORAL_CHRONO_UNIT = "java.time.temporal.ChronoUnit";
    private static final String JAVA_TIME_LOCAL_DATE = "java.time.LocalDate";
    private static final String PERIOD_CLASS = "java.time.Period";

    public LocalDateHelper(LocalDateDatatype datatype) {
        super(datatype);
    }

    @Override
    protected JavaCodeFragment valueOfExpression(String expression) {
        return ParseHelper.parse(expression, JAVA_TIME_LOCAL_DATE);
    }

    @Override
    public String getJavaClassName() {
        return JAVA_TIME_LOCAL_DATE;
    }

    @Override
    public JavaCodeFragment getPeriodCode(JavaCodeFragment arg1, JavaCodeFragment arg2, ILocalDateHelper.Period period) {
        JavaCodeFragment fragment = new JavaCodeFragment();
        if (ILocalDateHelper.Period.WEEKS == period) {
            fragment.append("(int) ");
        }
        fragment.appendClassName(PERIOD_CLASS).append(".between(").append(arg1).append(", ").append(arg2).append(")");
        switch (period) {
            case DAYS: {
                fragment.append(".getDays()");
                break;
            }
            case WEEKS: {
                fragment.append(".get(").appendClassName(JAVA_TIME_TEMPORAL_CHRONO_UNIT).append('.').append(WEEKS).append(')');
                break;
            }
            case MONTHS: {
                fragment.append(".getMonths()");
                break;
            }
            case YEARS: {
                fragment.append(".getYears()");
                break;
            }
        }
        return fragment;
    }

    @Override
    public JavaCodeFragment getDateInitialization(JavaCodeFragment year, JavaCodeFragment month, JavaCodeFragment day) {
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.appendClassName(this.getJavaClassName()).append(".of(").append(year).append(", ").append(month).append(", ").append(day).append(")");
        return fragment;
    }

    @Override
    public String getDateFieldEnumClass() {
        return JAVA_TIME_TEMPORAL_CHRONO_FIELD;
    }

    @Override
    public String getDayOfMonthField() {
        return DAY_OF_MONTH;
    }

    @Override
    public String getMonthOfYearField() {
        return MONTH_OF_YEAR;
    }

    @Override
    public String getYearField() {
        return YEAR;
    }
}

