/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.datatype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.faktorips.datatype.EnumDatatype;
import org.faktorips.datatype.GenericValueDatatype;
import org.faktorips.runtime.MessageList;
import org.faktorips.util.MethodAccess;

public abstract class GenericEnumDatatype
extends GenericValueDatatype
implements EnumDatatype {
    public static final String MSGCODE_PREFIX_GET_NAME_METHOD = "GENERIC DATATYPE-getNameMethod";
    private String getNameMethodName = "getName";
    private boolean isSupportingNames = false;
    private boolean cacheData = false;
    private String[] cachedValueIds = null;
    private String[] cachedValueNames = null;

    public boolean isCacheData() {
        return this.cacheData;
    }

    public void setCacheData(boolean cacheData) {
        this.cacheData = cacheData;
        if (!cacheData) {
            this.clearCache();
        }
    }

    private MethodAccess getNameMethod() {
        return MethodAccess.of(this.getAdaptedClass(), (String)this.getGetNameMethodName(), (Class[])new Class[0]);
    }

    @Override
    public MessageList checkReadyToUse() {
        MessageList ml = super.checkReadyToUse();
        this.getNameMethod().check(ml, MSGCODE_PREFIX_GET_NAME_METHOD).exists().isNotStatic().returnTypeIsCompatible(new Class[]{String.class});
        return ml;
    }

    public String getGetNameMethodName() {
        return this.getNameMethodName;
    }

    public void setGetNameMethodName(String getNameMethodName) {
        this.getNameMethodName = getNameMethodName;
        this.clearCache();
    }

    @Override
    public boolean isSupportingNames() {
        return this.isSupportingNames;
    }

    public void setIsSupportingNames(boolean isSupportingNames) {
        this.isSupportingNames = isSupportingNames;
        this.clearCache();
    }

    @Override
    public String[] getAllValueIds(boolean includeNull) {
        try {
            String[] ids = this.getAllValueIdsFromCache();
            if (ids == null) {
                ids = this.getAllValueIdsFromClass();
            }
            int indexOfNull = this.getIndeoxOfNullOrNullObject(ids);
            ArrayList<String> result = new ArrayList<String>();
            result.addAll(Arrays.asList(ids));
            if (!includeNull && indexOfNull >= 0) {
                result.remove(indexOfNull);
            } else if (includeNull && indexOfNull == -1) {
                if (this.hasNullObject()) {
                    result.add(this.getNullObjectId());
                } else {
                    result.add(null);
                }
            }
            return result.toArray(new String[result.size()]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error invoking method " + this.getAllValuesMethodName(), e);
        }
    }

    private String[] getAllValueIdsFromClass() {
        Object result = this.getAllValuesMethod().invokeStatic("to get all values", new Object[0]);
        Object[] values = result instanceof Collection ? ((Collection)result).toArray(Object[]::new) : (Object[])result;
        String[] ids = new String[values.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = this.valueToString(values[i]);
        }
        return ids;
    }

    private int getIndeoxOfNullOrNullObject(String[] valueIds) {
        for (int i = 0; i < valueIds.length; ++i) {
            if (valueIds[i] != null && (!this.hasNullObject() || !Objects.equals(valueIds[i], this.getNullObjectId()))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getValueName(String id) {
        if (!this.isSupportingNames) {
            throw new UnsupportedOperationException("This enumeration type does not support a getName(String) method, enumeration type class: " + String.valueOf(this.getAdaptedClass()));
        }
        String[] ids = this.getAllValueIdsFromCache();
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                if (!Objects.equals(id, ids[i])) continue;
                String[] names = this.getAllValueNamesFromCache();
                return names[i];
            }
        }
        return this.getValueNameFromClass(id);
    }

    private String getValueNameFromClass(String id) {
        Object value = this.getValue(id);
        return this.getNameFromValue(value);
    }

    protected String getNameFromValue(Object value) {
        if (value == null) {
            return null;
        }
        return (String)this.getNameMethod().invoke("to get the name for a value", value, new Object[0]);
    }

    @Override
    public boolean isParsable(String value) {
        if (value == null) {
            return true;
        }
        String[] ids = this.getAllValueIdsFromCache();
        if (ids == null) {
            return super.isParsable(value);
        }
        for (String id : ids) {
            if (!value.equals(id)) continue;
            return true;
        }
        return false;
    }

    String[] getAllValueIdsFromCache() {
        if (!this.cacheData) {
            return null;
        }
        if (this.cachedValueIds == null) {
            this.initCache();
        }
        return this.cachedValueIds;
    }

    String[] getAllValueNamesFromCache() {
        if (!this.isSupportingNames) {
            throw new RuntimeException("Datatype " + String.valueOf(this) + " does not support names.");
        }
        if (!this.cacheData) {
            return null;
        }
        if (this.cachedValueNames == null) {
            this.initCache();
        }
        return this.cachedValueNames;
    }

    public void initCache() {
        String[] ids;
        try {
            ids = this.getAllValueIdsFromClass();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing cache for datatype " + String.valueOf(this), e);
        }
        this.cachedValueIds = new String[ids.length];
        if (this.isSupportingNames) {
            this.cachedValueNames = new String[ids.length];
        }
        for (int i = 0; i < ids.length; ++i) {
            this.cachedValueIds[i] = ids[i];
            if (!this.isSupportingNames) continue;
            this.cachedValueNames[i] = this.getValueNameFromClass(ids[i]);
        }
    }

    @Override
    protected void clearCache() {
        super.clearCache();
        this.cachedValueIds = null;
        this.cachedValueNames = null;
    }
}

