/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.codegen;

import java.util.Objects;
import java.util.StringTokenizer;
import org.faktorips.runtime.util.StringBuilderJoiner;

public class CodeFragment {
    private static final String INDENT_HELPER = "                                                         ";
    private boolean indent = false;
    private StringBuilder sourcecode;
    private int indentation = 4;
    private int indentLevel = 0;

    public CodeFragment() {
        this(false);
    }

    public CodeFragment(boolean indent) {
        this.sourcecode = new StringBuilder(1024);
        this.indent = indent;
    }

    public CodeFragment(String sourcecode) {
        this();
        this.sourcecode = new StringBuilder(1024);
        this.sourcecode.append(sourcecode);
    }

    public CodeFragment(CodeFragment fragment) {
        this.sourcecode = fragment.sourcecode;
    }

    public String getSourcecode() {
        return this.sourcecode.toString();
    }

    public void incIndentationLevel() {
        ++this.indentLevel;
    }

    public void decIndentationLevel() {
        if (this.indentLevel == 0) {
            throw new RuntimeException("Indentation level can't be lesser than 0.");
        }
        --this.indentLevel;
    }

    public int getIndentationLevel() {
        return this.indentLevel;
    }

    public CodeFragment append(String s) {
        this.indentIfBol();
        this.sourcecode.append(s);
        return this;
    }

    public CodeFragment appendJoined(Iterable<?> iterable) {
        this.indentIfBol();
        StringBuilderJoiner.join((StringBuilder)this.sourcecode, iterable);
        return this;
    }

    public CodeFragment appendJoined(Object[] array) {
        this.indentIfBol();
        StringBuilderJoiner.join((StringBuilder)this.sourcecode, (Object[])array);
        return this;
    }

    public CodeFragment appendQuoted(String s) {
        this.append('\"');
        this.append(s);
        this.append('\"');
        return this;
    }

    public CodeFragment append(char c) {
        if (this.indent) {
            this.indentIfBol();
        }
        this.sourcecode.append(c);
        return this;
    }

    public CodeFragment appendln() {
        this.sourcecode.append(System.lineSeparator());
        return this;
    }

    public CodeFragment appendln(String s) {
        if (this.indent) {
            this.indentIfBol();
        }
        this.indentIfBol();
        this.sourcecode.append(s);
        this.sourcecode.append(System.lineSeparator());
        return this;
    }

    public CodeFragment appendlnUnindented(String arg) {
        this.sourcecode.append(arg);
        this.sourcecode.append(System.lineSeparator());
        return this;
    }

    public CodeFragment appendln(char c) {
        this.indentIfBol();
        this.sourcecode.append(c);
        this.sourcecode.append(System.lineSeparator());
        return this;
    }

    public CodeFragment append(CodeFragment fragment) {
        if (this.indent) {
            String fragmentSourcecode = fragment.getSourcecode();
            StringTokenizer tokenizer = new StringTokenizer(fragmentSourcecode, System.lineSeparator());
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) {
                    this.appendln(token);
                    continue;
                }
                this.append(token);
            }
            if (fragmentSourcecode.endsWith(System.lineSeparator())) {
                this.appendln("");
            }
        } else {
            this.sourcecode.append((CharSequence)fragment.sourcecode);
        }
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.sourcecode);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CodeFragment other = (CodeFragment)obj;
        return Objects.equals(this.sourcecode.toString(), other.sourcecode.toString());
    }

    public boolean bol() {
        int length = this.sourcecode.length();
        if (length == 0) {
            return true;
        }
        if (System.lineSeparator().length() == 1) {
            return this.sourcecode.charAt(length - 1) == System.lineSeparator().charAt(0);
        }
        if (System.lineSeparator().length() == 2) {
            if (length == 1) {
                return false;
            }
            return this.sourcecode.charAt(length - 2) == System.lineSeparator().charAt(0) && this.sourcecode.charAt(length - 1) == System.lineSeparator().charAt(1);
        }
        throw new RuntimeException("Unknown line separator [" + System.lineSeparator() + "]");
    }

    public String toString() {
        return this.sourcecode.toString();
    }

    private void indentIfBol() {
        if (!this.indent) {
            return;
        }
        if (this.bol()) {
            int length = this.indentation * this.indentLevel;
            if (length < INDENT_HELPER.length()) {
                this.sourcecode.append(INDENT_HELPER.substring(0, length));
            } else {
                this.sourcecode.append(INDENT_HELPER);
            }
        }
    }
}

