/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.datatype;

import java.util.Objects;
import org.faktorips.datatype.AbstractDatatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.runtime.internal.IpsStringUtils;

public abstract class AbstractPrimitiveDatatype
extends AbstractDatatype
implements ValueDatatype {
    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isValueDatatype() {
        return true;
    }

    @Override
    public String valueToString(Object value) {
        return String.valueOf(value);
    }

    @Override
    public boolean isParsable(String value) {
        if (IpsStringUtils.isEmpty((String)value)) {
            return false;
        }
        try {
            this.getValue(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public boolean hasNullObject() {
        return true;
    }

    @Override
    public abstract Object getValue(String var1);

    @Override
    public boolean areValuesEqual(String valueA, String valueB) {
        return Objects.equals(this.getValue(valueA), this.getValue(valueB));
    }

    @Override
    public int compare(String valueA, String valueB) {
        if (!this.supportsCompare()) {
            throw new UnsupportedOperationException("Datatype " + this.getQualifiedName() + " does not support comparison of values");
        }
        return ((Comparable)this.getValue(valueA)).compareTo(this.getValue(valueB));
    }

    @Override
    public String getNullObjectId() {
        return this.getDefaultValue();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }
}

