/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.codegen.dthelpers;

import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.codegen.dthelpers.AbstractDatatypeHelper;
import org.faktorips.datatype.classtypes.BooleanDatatype;
import org.faktorips.runtime.internal.IpsStringUtils;

public class BooleanHelper
extends AbstractDatatypeHelper {
    public BooleanHelper() {
    }

    public BooleanHelper(BooleanDatatype datatype) {
        super(datatype);
    }

    @Override
    public String getJavaClassName() {
        return Boolean.class.getName();
    }

    @Override
    public JavaCodeFragment newInstance(String value) {
        if (IpsStringUtils.isEmpty((String)value)) {
            return this.nullExpression();
        }
        boolean booleanValue = Boolean.parseBoolean(value);
        if (booleanValue) {
            return new JavaCodeFragment("Boolean.TRUE");
        }
        return new JavaCodeFragment("Boolean.FALSE");
    }

    @Override
    protected JavaCodeFragment valueOfExpression(String expression) {
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.appendClassName(Boolean.class);
        fragment.append(".valueOf(");
        fragment.append(expression);
        fragment.append(')');
        return fragment;
    }
}

