/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl;

import org.faktorips.codegen.BaseDatatypeHelper;
import org.faktorips.codegen.CodeFragment;
import org.faktorips.codegen.DatatypeHelper;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.fl.AbstractCompilationResult;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.ExprCompiler;
import org.faktorips.fl.UnaryOperation;
import org.faktorips.fl.parser.ASTAddNode;
import org.faktorips.fl.parser.ASTArgListNode;
import org.faktorips.fl.parser.ASTBooleanNode;
import org.faktorips.fl.parser.ASTDecimalNode;
import org.faktorips.fl.parser.ASTDivNode;
import org.faktorips.fl.parser.ASTEQNode;
import org.faktorips.fl.parser.ASTFunctionCallNode;
import org.faktorips.fl.parser.ASTGENode;
import org.faktorips.fl.parser.ASTGTNode;
import org.faktorips.fl.parser.ASTIdentifierNode;
import org.faktorips.fl.parser.ASTIntegerNode;
import org.faktorips.fl.parser.ASTLENode;
import org.faktorips.fl.parser.ASTLTNode;
import org.faktorips.fl.parser.ASTMinusNode;
import org.faktorips.fl.parser.ASTMoneyNode;
import org.faktorips.fl.parser.ASTMultNode;
import org.faktorips.fl.parser.ASTNotEQNode;
import org.faktorips.fl.parser.ASTNotNode;
import org.faktorips.fl.parser.ASTNullNode;
import org.faktorips.fl.parser.ASTParenthesisNode;
import org.faktorips.fl.parser.ASTPlusNode;
import org.faktorips.fl.parser.ASTStart;
import org.faktorips.fl.parser.ASTStringNode;
import org.faktorips.fl.parser.ASTSubNode;
import org.faktorips.fl.parser.FlParserVisitor;
import org.faktorips.fl.parser.SimpleNode;
import org.faktorips.runtime.Message;

public abstract class ParseTreeVisitor<T extends CodeFragment>
implements FlParserVisitor {
    private final ExprCompiler<T> compiler;

    protected ParseTreeVisitor(ExprCompiler<T> compiler) {
        this.compiler = compiler;
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        return null;
    }

    @Override
    public Object visit(ASTStart node, Object data) {
        SimpleNode childNode = (SimpleNode)node.jjtGetChild(0);
        return childNode.jjtAccept(this, data);
    }

    @Override
    public Object visit(ASTEQNode node, Object data) {
        return this.generateBinaryOperation("=", node, data);
    }

    @Override
    public Object visit(ASTNotEQNode node, Object data) {
        return this.generateBinaryOperation("!=", node, data);
    }

    @Override
    public Object visit(ASTLTNode node, Object data) {
        return this.generateBinaryOperation("<", node, data);
    }

    @Override
    public Object visit(ASTGTNode node, Object data) {
        return this.generateBinaryOperation(">", node, data);
    }

    @Override
    public Object visit(ASTLENode node, Object data) {
        return this.generateBinaryOperation("<=", node, data);
    }

    @Override
    public Object visit(ASTGENode node, Object data) {
        return this.generateBinaryOperation(">=", node, data);
    }

    @Override
    public Object visit(ASTAddNode node, Object data) {
        return this.generateBinaryOperation("+", node, data);
    }

    @Override
    public Object visit(ASTSubNode node, Object data) {
        return this.generateBinaryOperation("-", node, data);
    }

    @Override
    public Object visit(ASTMultNode node, Object data) {
        return this.generateBinaryOperation("*", node, data);
    }

    @Override
    public Object visit(ASTDivNode node, Object data) {
        return this.generateBinaryOperation("/", node, data);
    }

    @Override
    public Object visit(ASTPlusNode node, Object data) {
        return this.generateUnaryOperation("+", node, data);
    }

    @Override
    public Object visit(ASTMinusNode node, Object data) {
        return this.generateUnaryOperation("-", node, data);
    }

    @Override
    public Object visit(ASTNotNode node, Object data) {
        return this.generateUnaryOperation("!", node, data);
    }

    @Override
    public Object visit(ASTParenthesisNode node, Object data) {
        return this.generateUnaryOperation("()", node, data);
    }

    @Override
    public Object visit(ASTIdentifierNode node, Object data) {
        String identifier = node.getLastToken().toString();
        return this.compiler.getIdentifierResolver().compile(identifier, this.compiler, this.compiler.getLocale());
    }

    @Override
    public Object visit(ASTBooleanNode node, Object data) {
        return this.generateConstant(node, (Datatype)Datatype.PRIMITIVE_BOOLEAN);
    }

    @Override
    public Object visit(ASTIntegerNode node, Object data) {
        return this.generateConstant(node, (Datatype)Datatype.PRIMITIVE_INT);
    }

    @Override
    public Object visit(ASTDecimalNode node, Object data) {
        return this.generateConstant(node, (Datatype)Datatype.DECIMAL);
    }

    @Override
    public Object visit(ASTStringNode node, Object data) {
        String value = node.getLastToken().toString();
        return this.newCompilationResultImpl((T)value, (Datatype)Datatype.STRING);
    }

    protected abstract AbstractCompilationResult<T> newCompilationResultImpl(String var1, Datatype var2);

    protected abstract AbstractCompilationResult<T> newCompilationResultImpl(T var1, Datatype var2);

    protected abstract AbstractCompilationResult<T> newCompilationResultImpl(Message var1);

    protected abstract AbstractCompilationResult<T> newCompilationResultImpl();

    @Override
    public Object visit(ASTMoneyNode node, Object data) {
        boolean isParsable = ((ValueDatatype)DatatypeHelper.MONEY.getDatatype()).isParsable(node.getLastToken().toString());
        if (isParsable) {
            return this.generateConstant(node, (Datatype)Datatype.MONEY);
        }
        String text = ExprCompiler.getLocalizedStrings().getString("FLC-Money", this.compiler.getLocale(), new Object[]{node.getLastToken().toString()});
        return this.newCompilationResultImpl(Message.newError((String)"FLC-SyntaxError", (String)text));
    }

    @Override
    public Object visit(ASTNullNode node, Object data) {
        String text = ExprCompiler.getLocalizedStrings().getString("FLC-NullNotAllowed", this.compiler.getLocale());
        return this.newCompilationResultImpl(Message.newError((String)"FLC-UndefinedIdentifier", (String)text));
    }

    @Override
    public Object visit(ASTFunctionCallNode node, Object data) {
        AbstractCompilationResult<T>[] argResults = this.getCompilationResultForFunctionArguments(node, data);
        AbstractCompilationResult<T> result = this.createNewResultAndCopyErrorMessagesIfExistent(argResults);
        if (result.failed()) {
            return result;
        }
        Datatype[] argTypes = result.getDatatypes(argResults);
        String fctName = node.getFirstToken().toString();
        return this.compiler.getMatchingFunctionUsingConversion(argResults, argTypes, fctName);
    }

    private AbstractCompilationResult<T> createNewResultAndCopyErrorMessagesIfExistent(AbstractCompilationResult<T>[] argResults) {
        AbstractCompilationResult<T> result = this.newCompilationResultImpl();
        for (AbstractCompilationResult<T> argResult : argResults) {
            if (!argResult.failed()) continue;
            result.addMessages(argResult.getMessages());
        }
        return result;
    }

    private AbstractCompilationResult<T>[] getCompilationResultForFunctionArguments(ASTFunctionCallNode node, Object data) {
        AbstractCompilationResult[] argResults;
        if (node.jjtGetNumChildren() == 0) {
            AbstractCompilationResult[] compilationResultImpls;
            argResults = compilationResultImpls = new AbstractCompilationResult[0];
        } else {
            AbstractCompilationResult[] compilationResultImpls = (AbstractCompilationResult[])node.jjtGetChild(0).jjtAccept(this, data);
            argResults = compilationResultImpls;
        }
        return argResults;
    }

    @Override
    public Object visit(ASTArgListNode node, Object data) {
        int numOfArgs = node.jjtGetNumChildren();
        AbstractCompilationResult[] argListResult = new AbstractCompilationResult[numOfArgs];
        for (int i = 0; i < numOfArgs; ++i) {
            AbstractCompilationResult compilationResultImpl;
            SimpleNode argNode = (SimpleNode)node.jjtGetChild(i);
            argListResult[i] = compilationResultImpl = (AbstractCompilationResult)argNode.jjtAccept(this, data);
        }
        return argListResult;
    }

    protected CompilationResult<T> generateConstant(SimpleNode node, Datatype datatype) {
        BaseDatatypeHelper<T> helper = this.compiler.getDatatypeHelper(datatype);
        if (helper == null) {
            String text = ExprCompiler.getLocalizedStrings().getString("FLC-DatatypeCreationError", this.compiler.getLocale(), new Object[]{datatype.getName()});
            return this.newCompilationResultImpl(Message.newError((String)"FLC-DatatypeCreationError", (String)text));
        }
        String value = node.getLastToken().toString();
        return this.newCompilationResultImpl(helper.newInstance(value), datatype);
    }

    private CompilationResult<T> generateUnaryOperation(String operator, SimpleNode node, Object data) {
        UnaryOperation<T>[] operations;
        SimpleNode argNode = (SimpleNode)node.jjtGetChild(0);
        AbstractCompilationResult argResult = (AbstractCompilationResult)argNode.jjtAccept(this, data);
        if (argResult.failed()) {
            return argResult;
        }
        UnaryOperation<CodeFragment> operation = null;
        for (UnaryOperation<CodeFragment> unaryOperation : operations = this.compiler.getUnaryOperations(operator)) {
            if (unaryOperation.getDatatype().equals(argResult.getDatatype())) {
                return unaryOperation.generate(argResult);
            }
            if (!this.compiler.getConversionCodeGenerator().canConvert(argResult.getDatatype(), unaryOperation.getDatatype())) continue;
            operation = unaryOperation;
        }
        if (operation != null) {
            CodeFragment converted = this.compiler.getConversionCodeGenerator().getConversionCode(argResult.getDatatype(), operation.getDatatype(), argResult.getCodeFragment());
            AbstractCompilationResult<CodeFragment> convertedArgResult = this.newCompilationResultImpl(converted, operation.getDatatype());
            convertedArgResult.addMessages(argResult.getMessages());
            return operation.generate(convertedArgResult);
        }
        Object[] replacements = new Object[]{operator, argResult.getDatatype().getName()};
        String text = ExprCompiler.getLocalizedStrings().getString("FLC-UndefinedOperator", this.compiler.getLocale(), replacements);
        return this.newCompilationResultImpl(Message.newError((String)"FLC-UndefinedOperator", (String)text));
    }

    private CompilationResult<T> generateBinaryOperation(String operator, SimpleNode node, Object data) {
        SimpleNode lhsNode = (SimpleNode)node.jjtGetChild(0);
        SimpleNode rhsNode = (SimpleNode)node.jjtGetChild(1);
        AbstractCompilationResult lhsResult = (AbstractCompilationResult)lhsNode.jjtAccept(this, data);
        AbstractCompilationResult rhsResult = (AbstractCompilationResult)rhsNode.jjtAccept(this, data);
        if (lhsResult.failed()) {
            lhsResult.addMessages(rhsResult.getMessages());
            return lhsResult;
        }
        if (rhsResult.failed()) {
            return rhsResult;
        }
        return this.compiler.getBinaryOperation(operator, lhsResult, rhsResult);
    }
}

