/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.functions;

import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.NumericDatatype;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.fl.FunctionSignatures;
import org.faktorips.fl.functions.AbstractListFunction;
import org.faktorips.fl.functions.Messages;
import org.faktorips.runtime.Message;

public class SumList
extends AbstractListFunction {
    static final String MSG_CODE_SUM_INVALID_DATATYPE = "FLC-SUM-INVALID-DATATYPE";

    public SumList(String name, String description) {
        super(name, description, FunctionSignatures.SumList);
    }

    @Override
    protected CompilationResult<JavaCodeFragment> validateBasicDatatype(Datatype basicDatatype) {
        if (!this.isNumeric(basicDatatype)) {
            return this.createInvalidDatatypeResult(basicDatatype);
        }
        return super.validateBasicDatatype(basicDatatype);
    }

    private boolean isNumeric(Datatype basicDatatype) {
        return basicDatatype instanceof NumericDatatype;
    }

    private CompilationResult<JavaCodeFragment> createInvalidDatatypeResult(Datatype basicDatatype) {
        String text = Messages.INSTANCE.getString(MSG_CODE_SUM_INVALID_DATATYPE, new Object[]{this.getName(), basicDatatype.getName()});
        return new CompilationResultImpl(Message.newError((String)MSG_CODE_SUM_INVALID_DATATYPE, (String)text));
    }

    @Override
    protected JavaCodeFragment generateReturnFallBackValueCall(Datatype datatype) {
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.append("return ");
        fragment.append(this.getDatatypeHelper(datatype).newInstance("0"));
        return fragment;
    }

    @Override
    protected CompilationResult<JavaCodeFragment> generateFunctionCall(CompilationResultImpl argument1, CompilationResultImpl argument2) {
        return new CompilationResultImpl(this.getCompiler().getBinaryOperation("+", argument1, argument2).getCodeFragment(), argument1.getDatatype());
    }
}

