/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.functions;

import org.faktorips.codegen.DatatypeHelper;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.fl.FunctionSignatures;
import org.faktorips.fl.functions.AbstractFlFunction;
import org.faktorips.util.ArgumentCheck;

public class TextFunction
extends AbstractFlFunction {
    public TextFunction(String name, String description) {
        super(name, description, FunctionSignatures.TextFunction);
    }

    @Override
    public CompilationResult<JavaCodeFragment> compile(CompilationResult<JavaCodeFragment>[] argResults) {
        ArgumentCheck.length((Object[])argResults, (int)1);
        JavaCodeFragment argumentFragment = argResults[0].getCodeFragment();
        DatatypeHelper datatypeHelper = this.getCompiler().getDatatypeHelper(argResults[0].getDatatype());
        JavaCodeFragment fragment = datatypeHelper != null ? this.getToStringFragment(argumentFragment, datatypeHelper) : this.getFallbackToStringFragment(argumentFragment);
        return new CompilationResultImpl(fragment, (Datatype)Datatype.STRING);
    }

    private JavaCodeFragment getToStringFragment(JavaCodeFragment argumentFragment, DatatypeHelper datatypeHelper) {
        JavaCodeFragment fragment = new JavaCodeFragment("", argumentFragment.getImportDeclaration());
        fragment.append("(").append(datatypeHelper.getToStringExpression(argumentFragment.getSourcecode())).append(")");
        return fragment;
    }

    private JavaCodeFragment getFallbackToStringFragment(JavaCodeFragment argumentFragment) {
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.appendClassName(String.class).append(".valueOf(").append(argumentFragment).append(")");
        return fragment;
    }
}

