/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.functions;

import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.fl.FunctionSignatures;
import org.faktorips.fl.functions.AbstractFlFunction;
import org.faktorips.util.ArgumentCheck;

public class PowerInt
extends AbstractFlFunction {
    private static final String CONVERT_TO_INT = "(int)";
    private static final String MATH_POW = "Math.pow";

    public PowerInt(String name, String description) {
        super(name, description, FunctionSignatures.PowerInt);
    }

    @Override
    public CompilationResult<JavaCodeFragment> compile(CompilationResult<JavaCodeFragment>[] argResults) {
        ArgumentCheck.length((Object[])argResults, (int)2);
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.append(CONVERT_TO_INT);
        fragment.append(MATH_POW);
        fragment.append('(');
        fragment.append(argResults[0].getCodeFragment());
        fragment.append(',');
        fragment.append(argResults[1].getCodeFragment());
        fragment.append(')');
        CompilationResultImpl result = this.createCompilationResultImpl(fragment);
        result.addMessages(argResults[0].getMessages());
        result.addMessages(argResults[1].getMessages());
        return result;
    }

    private CompilationResultImpl createCompilationResultImpl(JavaCodeFragment fragmentResult) {
        return new CompilationResultImpl(fragmentResult, (Datatype)Datatype.PRIMITIVE_INT);
    }
}

