/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl;

import java.math.RoundingMode;
import java.util.Locale;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.joda.LocalDateDatatype;
import org.faktorips.fl.ExcelFunction;
import org.faktorips.fl.LocalizedFunctionsResolver;
import org.faktorips.fl.functions.Abs;
import org.faktorips.fl.functions.And;
import org.faktorips.fl.functions.Count;
import org.faktorips.fl.functions.If;
import org.faktorips.fl.functions.IfBoolean;
import org.faktorips.fl.functions.IsEmpty;
import org.faktorips.fl.functions.MinMaxComparableDatatypes;
import org.faktorips.fl.functions.MinMaxDecimal;
import org.faktorips.fl.functions.MinMaxDouble;
import org.faktorips.fl.functions.MinMaxInt;
import org.faktorips.fl.functions.MinMaxLong;
import org.faktorips.fl.functions.MinMaxMoney;
import org.faktorips.fl.functions.Not;
import org.faktorips.fl.functions.NotBoolean;
import org.faktorips.fl.functions.Or;
import org.faktorips.fl.functions.PowerDecimal;
import org.faktorips.fl.functions.PowerInt;
import org.faktorips.fl.functions.Round;
import org.faktorips.fl.functions.SqrtDecimal;
import org.faktorips.fl.functions.TextFunction;
import org.faktorips.fl.functions.WholeNumber;
import org.faktorips.fl.functions.date.Date;
import org.faktorips.fl.functions.date.Days;
import org.faktorips.fl.functions.date.Days360;
import org.faktorips.fl.functions.date.Months;
import org.faktorips.fl.functions.date.Weeks;
import org.faktorips.fl.functions.date.Years;

public class ExcelFunctionsResolver
extends LocalizedFunctionsResolver<JavaCodeFragment> {
    public ExcelFunctionsResolver(Locale locale) {
        super(locale);
        this.add(new Abs(this.getFctName(ExcelFunction.ABS), this.getFctDescription(ExcelFunction.ABS)));
        this.add(new IfBoolean(this.getFctName(ExcelFunction.IF), this.getFctDescription(ExcelFunction.IF)));
        this.add(new If(this.getFctName(ExcelFunction.IF), this.getFctDescription(ExcelFunction.IF)));
        this.add(new Or(this.getFctName(ExcelFunction.OR), this.getFctDescription(ExcelFunction.OR)));
        this.add(new And(this.getFctName(ExcelFunction.AND), this.getFctDescription(ExcelFunction.AND)));
        this.add(new Round(this.getFctName(ExcelFunction.ROUND), this.getFctDescription(ExcelFunction.ROUND), RoundingMode.HALF_UP));
        this.add(new Round(this.getFctName(ExcelFunction.ROUNDUP), this.getFctDescription(ExcelFunction.ROUNDUP), RoundingMode.UP));
        this.add(new Round(this.getFctName(ExcelFunction.ROUNDDOWN), this.getFctDescription(ExcelFunction.ROUNDDOWN), RoundingMode.DOWN));
        this.add(new WholeNumber(this.getFctName(ExcelFunction.WHOLENUMBER), this.getFctDescription(ExcelFunction.WHOLENUMBER)));
        this.add(new IsEmpty(this.getFctName(ExcelFunction.ISEMPTY), this.getFctDescription(ExcelFunction.ISEMPTY)));
        this.add(new Not(this.getFctName(ExcelFunction.NOT), this.getFctDescription(ExcelFunction.NOT)));
        this.add(new NotBoolean(this.getFctName(ExcelFunction.NOT), this.getFctDescription(ExcelFunction.NOT)));
        this.add(new MinMaxMoney(this.getFctName(ExcelFunction.MAX), this.getFctDescription(ExcelFunction.MAX), true));
        this.add(new MinMaxMoney(this.getFctName(ExcelFunction.MIN), this.getFctDescription(ExcelFunction.MIN), false));
        this.add(new MinMaxDecimal(this.getFctName(ExcelFunction.MAX), this.getFctDescription(ExcelFunction.MAX), true));
        this.add(new MinMaxDecimal(this.getFctName(ExcelFunction.MIN), this.getFctDescription(ExcelFunction.MIN), false));
        this.add(new MinMaxInt(this.getFctName(ExcelFunction.MAX), this.getFctDescription(ExcelFunction.MAX), true));
        this.add(new MinMaxInt(this.getFctName(ExcelFunction.MIN), this.getFctDescription(ExcelFunction.MIN), false));
        this.add(new MinMaxLong(this.getFctName(ExcelFunction.MAX), this.getFctDescription(ExcelFunction.MAX), true));
        this.add(new MinMaxLong(this.getFctName(ExcelFunction.MIN), this.getFctDescription(ExcelFunction.MIN), false));
        this.add(new MinMaxDouble(this.getFctName(ExcelFunction.MAX), this.getFctDescription(ExcelFunction.MAX), true));
        this.add(new MinMaxDouble(this.getFctName(ExcelFunction.MIN), this.getFctDescription(ExcelFunction.MIN), false));
        this.add(new MinMaxComparableDatatypes(this.getFctName(ExcelFunction.MIN), this.getFctDescription(ExcelFunction.MIN), false, (Datatype)LocalDateDatatype.DATATYPE));
        this.add(new MinMaxComparableDatatypes(this.getFctName(ExcelFunction.MAX), this.getFctDescription(ExcelFunction.MAX), true, (Datatype)LocalDateDatatype.DATATYPE));
        this.add(new PowerDecimal(this.getFctName(ExcelFunction.POWER), this.getFctDescription(ExcelFunction.POWER)));
        this.add(new PowerInt(this.getFctName(ExcelFunction.POWER), this.getFctDescription(ExcelFunction.POWER)));
        this.add(new SqrtDecimal(this.getFctName(ExcelFunction.SQRT), this.getFctDescription(ExcelFunction.SQRT)));
        this.add(new Count(this.getFctName(ExcelFunction.COUNT), this.getFctDescription(ExcelFunction.COUNT)));
        this.add(new Days(this.getFctName(ExcelFunction.DAYS), this.getFctDescription(ExcelFunction.DAYS)));
        this.add(new Weeks(this.getFctName(ExcelFunction.WEEKS), this.getFctDescription(ExcelFunction.WEEKS)));
        this.add(new Months(this.getFctName(ExcelFunction.MONTHS), this.getFctDescription(ExcelFunction.MONTHS)));
        this.add(new Years(this.getFctName(ExcelFunction.YEARS), this.getFctDescription(ExcelFunction.YEARS)));
        this.add(new Date(this.getFctName(ExcelFunction.DATE), this.getFctDescription(ExcelFunction.DATE)));
        this.add(new Days360(this.getFctName(ExcelFunction.DAYS360), this.getFctDescription(ExcelFunction.DAYS360)));
        this.add(new TextFunction(this.getFctName(ExcelFunction.TEXT), this.getFctDescription(ExcelFunction.TEXT)));
    }

    public String toString() {
        return "ExcelFunctionResolver";
    }

    @Override
    protected String getLocalizationFileBaseName() {
        return "org.faktorips.fl.ExcelFunctions";
    }

    private String getFctName(ExcelFunction function) {
        return this.getFctName(function.getPropertyKey());
    }

    private String getFctDescription(ExcelFunction function) {
        return this.getFctDescription(function.getPropertyKey());
    }
}

