/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.functions;

import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.fl.FunctionSignatures;
import org.faktorips.fl.functions.AbstractListFunction;
import org.faktorips.fl.functions.Messages;
import org.faktorips.runtime.Message;

public class MinMaxList
extends AbstractListFunction {
    private static final String MSG_CODE_INVALID_DATATYPE = "FLC-MIN_MAX_LIST_INVALID_DATATYPE";

    public MinMaxList(String name, String description, boolean isMax) {
        super(name, description, isMax ? FunctionSignatures.MaxList : FunctionSignatures.MinList);
    }

    @Override
    protected CompilationResult<JavaCodeFragment> validateBasicDatatype(Datatype basicDatatype) {
        if (!this.supportsCompare(basicDatatype)) {
            return this.createInvalidDatatypeResult(basicDatatype);
        }
        return super.validateBasicDatatype(basicDatatype);
    }

    private CompilationResultImpl createInvalidDatatypeResult(Datatype basicDatatype) {
        String messageText = Messages.INSTANCE.getString(MSG_CODE_INVALID_DATATYPE, new Object[]{this.getName(), basicDatatype.getName()});
        return new CompilationResultImpl(Message.newError((String)MSG_CODE_INVALID_DATATYPE, (String)messageText));
    }

    private boolean supportsCompare(Datatype basicDatatype) {
        return basicDatatype.isValueDatatype() && ((ValueDatatype)basicDatatype).supportsCompare();
    }

    @Override
    protected JavaCodeFragment generateReturnFallBackValueCall(Datatype datatype) {
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.append("throw new ");
        fragment.appendClassName(IllegalArgumentException.class);
        fragment.append("(\"List argument is empty or null\")");
        return fragment;
    }
}

