/*******************************************************************************
 * Copyright (c) Faktor Zehn GmbH - faktorzehn.org
 * 
 * This source code is available under the terms of the AGPL Affero General Public License version
 * 3.
 * 
 * Please see LICENSE.txt for full license terms, including the additional permissions and
 * restrictions as well as the possibility of alternative license terms.
 *******************************************************************************/

/* Generated By:JJTree: Do not edit this line. Node.java */

package org.faktorips.fl.parser;

/*
 * All AST nodes must implement this interface. It provides basic machinery for constructing the
 * parent and child relationships between nodes.
 */

public interface Node {

    /**
     * This method is called after the node has been made the current node. It indicates that child
     * nodes can now be added to it.
     */
    void jjtOpen();

    /**
     * This method is called after all the child nodes have been added.
     */
    void jjtClose();

    /**
     * This pair of methods are used to inform the node of its parent.
     */
    void jjtSetParent(Node n);

    Node jjtGetParent();

    /**
     * This method tells the node to add its argument to the node's list of children.
     */
    void jjtAddChild(Node n, int i);

    /**
     * This method returns a child node. The children are numbered from zero, left to right.
     */
    Node jjtGetChild(int i);

    /** Return the number of children the node has. */
    int jjtGetNumChildren();

    /** Accept the visitor. **/
    Object jjtAccept(FlParserVisitor visitor, Object data);
}
