/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.functions;

import org.faktorips.codegen.CodeFragment;
import org.faktorips.codegen.ConversionCodeGenerator;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.fl.FunctionSignatures;
import org.faktorips.fl.functions.AbstractFlFunction;
import org.faktorips.fl.functions.Messages;
import org.faktorips.runtime.Message;
import org.faktorips.util.ArgumentCheck;

public class AbstractIf
extends AbstractFlFunction {
    public static final String ERROR_MESSAGE_CODE = "FLC-IF";

    public AbstractIf(String name, String description, FunctionSignatures signature) {
        super(name, description, signature);
    }

    @Override
    public CompilationResult<JavaCodeFragment> compile(CompilationResult<JavaCodeFragment>[] argResults) {
        ArgumentCheck.length((Object[])argResults, (int)3);
        ConversionCodeGenerator ccg = this.getCompiler().getConversionCodeGenerator();
        Datatype datatype1 = argResults[1].getDatatype();
        Datatype datatype2 = argResults[2].getDatatype();
        if (!datatype1.equals(datatype2)) {
            CompilationResultImpl newResult;
            JavaCodeFragment converted;
            if (ccg.canConvert(datatype1, datatype2)) {
                converted = (JavaCodeFragment)ccg.getConversionCode(datatype1, datatype2, (CodeFragment)argResults[1].getCodeFragment());
                newResult = new CompilationResultImpl(converted, datatype2);
                newResult.addMessages(argResults[1].getMessages());
                argResults[1] = newResult;
            } else if (ccg.canConvert(datatype2, datatype1)) {
                converted = (JavaCodeFragment)ccg.getConversionCode(datatype2, datatype1, (CodeFragment)argResults[2].getCodeFragment());
                newResult = new CompilationResultImpl(converted, datatype1);
                newResult.addMessages(argResults[2].getMessages());
                argResults[2] = newResult;
            } else {
                String text = Messages.INSTANCE.getString(ERROR_MESSAGE_CODE, new Object[]{datatype1, datatype2});
                Message msg = Message.newError((String)ERROR_MESSAGE_CODE, (String)text);
                return new CompilationResultImpl(msg);
            }
        }
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.append("(");
        fragment.append(argResults[0].getCodeFragment());
        fragment.append('?');
        fragment.append(argResults[1].getCodeFragment());
        fragment.append(':');
        fragment.append(argResults[2].getCodeFragment());
        fragment.append(")");
        CompilationResultImpl result = new CompilationResultImpl(fragment, argResults[1].getDatatype());
        result.addMessages(argResults[0].getMessages());
        result.addMessages(argResults[1].getMessages());
        result.addMessages(argResults[2].getMessages());
        return result;
    }
}

