/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.functions;

import java.util.ArrayList;
import org.faktorips.codegen.CodeFragment;
import org.faktorips.codegen.ConversionCodeGenerator;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.fl.FunctionSignatures;
import org.faktorips.fl.functions.AbstractBaseVarArgFunction;
import org.faktorips.fl.functions.Messages;
import org.faktorips.runtime.Message;

public abstract class AbstractVarArgFunction
extends AbstractBaseVarArgFunction<JavaCodeFragment> {
    public AbstractVarArgFunction(String name, String description, FunctionSignatures signature) {
        super(name, description, signature);
    }

    public AbstractVarArgFunction(String name, String description, Datatype type, Datatype argType) {
        super(name, description, type, argType);
    }

    @Override
    public CompilationResult<JavaCodeFragment> compile(CompilationResult<JavaCodeFragment>[] argResults) {
        ConversionCodeGenerator ccg = this.getCompiler().getConversionCodeGenerator();
        ArrayList<CompilationResultImpl> convertedResults = new ArrayList<CompilationResultImpl>(argResults.length);
        Datatype expectedArgType = this.getExpectedDatatypeForArgResultConversion(argResults);
        for (int i = 0; i < argResults.length; ++i) {
            CompilationResultImpl newResult = (CompilationResultImpl)argResults[i];
            Datatype argDatatype = argResults[i].getDatatype();
            if (!expectedArgType.equals(argDatatype)) {
                if (!ccg.canConvert(argDatatype, expectedArgType)) {
                    String text = Messages.INSTANCE.getString("FLC-VARARG", new Object[]{expectedArgType, i, argDatatype});
                    Message msg = Message.newError((String)"FLC-VARARG", (String)text);
                    return new CompilationResultImpl(msg);
                }
                JavaCodeFragment converted = (JavaCodeFragment)ccg.getConversionCode(argDatatype, expectedArgType, (CodeFragment)argResults[i].getCodeFragment());
                newResult = new CompilationResultImpl(converted, expectedArgType);
                newResult.addMessages(argResults[i].getMessages());
            }
            convertedResults.add(newResult);
        }
        JavaCodeFragment fragment = new JavaCodeFragment();
        CompilationResultImpl returnValue = new CompilationResultImpl(fragment, this.getType());
        CompilationResult[] compilationResults = new CompilationResult[convertedResults.size()];
        this.compileInternal(returnValue, convertedResults.toArray(compilationResults), fragment);
        for (CompilationResultImpl compilationResult : convertedResults) {
            returnValue.addMessages(compilationResult.getMessages());
        }
        return returnValue;
    }
}

