/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.functions.date;

import org.faktorips.codegen.DatatypeHelper;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.codegen.dthelpers.ILocalDateHelper;
import org.faktorips.datatype.Datatype;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.fl.FunctionSignatures;
import org.faktorips.fl.functions.AbstractFlFunction;
import org.faktorips.fl.functions.Messages;
import org.faktorips.runtime.Message;
import org.faktorips.util.ArgumentCheck;

public class Days360
extends AbstractFlFunction {
    public Days360(String name, String description) {
        super(name, description, FunctionSignatures.DAYS360);
    }

    @Override
    public CompilationResult<JavaCodeFragment> compile(CompilationResult<JavaCodeFragment>[] argResults) {
        ArgumentCheck.length((Object[])argResults, (int)2);
        Datatype datatype = this.getArgTypes()[0];
        DatatypeHelper datatypeHelper = this.getDatatypeHelper(datatype);
        if (datatypeHelper instanceof ILocalDateHelper) {
            ILocalDateHelper localDateHelper = (ILocalDateHelper)datatypeHelper;
            JavaCodeFragment d1 = argResults[0].getCodeFragment();
            JavaCodeFragment d2 = argResults[1].getCodeFragment();
            JavaCodeFragment fragment = new JavaCodeFragment();
            fragment.append("((").append(d2);
            this.appendGetField(fragment, localDateHelper.getDateFieldEnumClass(), localDateHelper.getYearField());
            fragment.append(" - ").append(d1);
            this.appendGetField(fragment, localDateHelper.getDateFieldEnumClass(), localDateHelper.getYearField());
            fragment.append(") * 360 + ").append("(").append(d2);
            this.appendGetField(fragment, localDateHelper.getDateFieldEnumClass(), localDateHelper.getMonthOfYearField());
            fragment.append(" - ").append(d1);
            this.appendGetField(fragment, localDateHelper.getDateFieldEnumClass(), localDateHelper.getMonthOfYearField());
            fragment.append(") * 30 + ").append("(Math.min(").append(d2);
            this.appendGetField(fragment, localDateHelper.getDateFieldEnumClass(), localDateHelper.getDayOfMonthField());
            fragment.append(", 30)").append(" - ").append("Math.min(").append(d1);
            this.appendGetField(fragment, localDateHelper.getDateFieldEnumClass(), localDateHelper.getDayOfMonthField());
            fragment.append(", 30)))");
            return new CompilationResultImpl(fragment, this.getType());
        }
        String code = "FLC-NO_PERIOD_SUPPORT";
        String text = Messages.INSTANCE.getString(code, new Object[]{datatype});
        Message msg = Message.newError((String)code, (String)text);
        return new CompilationResultImpl(msg);
    }

    private void appendGetField(JavaCodeFragment fragment, String dateFieldEnumClass, String field) {
        fragment.append(".get(").appendClassName(dateFieldEnumClass).append('.').append(field).append(')');
    }
}

