/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.functions;

import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.fl.functions.AbstractFlFunction;
import org.faktorips.util.ArgumentCheck;

public class MinMaxComparableDatatypes
extends AbstractFlFunction {
    private boolean isMax;
    private Datatype datatype;

    public MinMaxComparableDatatypes(String name, String description, boolean isMax, Datatype datatype) {
        super(name, description, datatype, new Datatype[]{datatype, datatype});
        this.isMax = isMax;
        this.datatype = datatype;
    }

    @Override
    public CompilationResult<JavaCodeFragment> compile(CompilationResult<JavaCodeFragment>[] argResults) {
        ArgumentCheck.length((Object[])argResults, (int)2);
        JavaCodeFragment p1 = argResults[0].getCodeFragment();
        JavaCodeFragment p2 = argResults[1].getCodeFragment();
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.append("(").append(p1).append(".compareTo(").append(p2).append(")");
        if (this.isMax) {
            fragment.append(" > ");
        } else {
            fragment.append(" < ");
        }
        fragment.append("0 ? ").append(p1).append(" : ").append(p2).append(")");
        CompilationResultImpl result = new CompilationResultImpl(fragment, this.datatype);
        result.addMessages(argResults[0].getMessages());
        result.addMessages(argResults[1].getMessages());
        return result;
    }
}

