/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.functions;

import org.faktorips.codegen.DatatypeHelper;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ListOfTypeDatatype;
import org.faktorips.datatype.classtypes.StringDatatype;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.fl.FunctionSignatures;
import org.faktorips.fl.functions.AbstractFlFunction;

public class IsEmpty
extends AbstractFlFunction {
    public static final String ERROR_MESSAGE_CODE = "FLC-ISEMPTY";

    public IsEmpty(String name, String description) {
        super(name, description, FunctionSignatures.IsEmpty);
    }

    @Override
    public CompilationResult<JavaCodeFragment> compile(CompilationResult<JavaCodeFragment>[] argResults) {
        Datatype argType = argResults[0].getDatatype();
        if (argType.isPrimitive()) {
            return new CompilationResultImpl("false", (Datatype)Datatype.PRIMITIVE_BOOLEAN);
        }
        JavaCodeFragment code = new JavaCodeFragment();
        if (argType instanceof ListOfTypeDatatype) {
            code.append(argResults[0].getCodeFragment());
            code.append(".isEmpty()");
        } else if (argType.hasNullObject()) {
            DatatypeHelper helper = this.getCompiler().getDatatypeHelper(argType);
            code.append((JavaCodeFragment)helper.nullExpression());
            code.append(".equals(");
            code.append(argResults[0].getCodeFragment());
            code.append(")");
        } else if (argType instanceof StringDatatype) {
            code.append(this.compileIsEmptyForStrings(argResults[0].getCodeFragment()));
        } else {
            code.append(argResults[0].getCodeFragment());
            code.append("==null");
        }
        return new CompilationResultImpl(code, (Datatype)Datatype.PRIMITIVE_BOOLEAN);
    }

    private JavaCodeFragment compileIsEmptyForStrings(JavaCodeFragment paramName) {
        return new JavaCodeFragment().append(paramName).append("==null").append("||").append(paramName).append(".isEmpty()");
    }
}

