/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.functions.date;

import org.faktorips.codegen.DatatypeHelper;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.codegen.dthelpers.ILocalDateHelper;
import org.faktorips.datatype.Datatype;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.fl.FunctionSignatures;
import org.faktorips.fl.functions.AbstractFlFunction;
import org.faktorips.fl.functions.Messages;
import org.faktorips.runtime.Message;
import org.faktorips.util.ArgumentCheck;

public abstract class AbstractPeriodFunction
extends AbstractFlFunction {
    static final String NO_PERIOD_SUPPORT = "NO_PERIOD_SUPPORT";
    private ILocalDateHelper.Period period;

    public AbstractPeriodFunction(String name, String description, FunctionSignatures functionSignature, ILocalDateHelper.Period period) {
        super(name, description, functionSignature);
        this.period = period;
    }

    @Override
    public CompilationResult<JavaCodeFragment> compile(CompilationResult<JavaCodeFragment>[] argResults) {
        ArgumentCheck.length((Object[])argResults, (int)2);
        Datatype datatype = this.getArgTypes()[0];
        DatatypeHelper datatypeHelper = this.getDatatypeHelper(datatype);
        if (datatypeHelper instanceof ILocalDateHelper) {
            JavaCodeFragment fragment = ((ILocalDateHelper)datatypeHelper).getPeriodCode(argResults[0].getCodeFragment(), argResults[1].getCodeFragment(), this.period);
            return new CompilationResultImpl(fragment, this.getType());
        }
        String code = "FLC-NO_PERIOD_SUPPORT";
        String text = Messages.INSTANCE.getString(code, new Object[]{datatype});
        Message msg = Message.newError((String)code, (String)text);
        return new CompilationResultImpl(msg);
    }
}

