/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl;

import bsh.Interpreter;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.JavaExprCompiler;
import org.faktorips.util.ArgumentCheck;

public class ExprEvaluator {
    private JavaExprCompiler compiler;
    private ClassLoader classLoader;

    public ExprEvaluator(JavaExprCompiler compiler) {
        ArgumentCheck.notNull((Object)compiler);
        this.compiler = compiler;
    }

    public ExprEvaluator(JavaExprCompiler compiler, ClassLoader classLoader) {
        this(compiler);
        this.classLoader = classLoader;
    }

    public Object evaluate(String expression) throws Exception {
        JavaCodeFragment fragment = this.compileExpressionToJava(expression);
        Interpreter i = new Interpreter();
        if (this.classLoader != null) {
            i.setClassLoader(this.classLoader);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(fragment.getImportDeclaration().toString());
        sb.append(System.lineSeparator());
        sb.append(fragment.getSourcecode());
        return i.eval(sb.toString());
    }

    public Object evaluate(String expression, String[] variables, Object[] variableValues) throws Exception {
        ArgumentCheck.length((Object[])variableValues, (int)variables.length, (Object)"the variableValues parameter and the variables parameter need to have the same amount of values.");
        Interpreter interpreter = new Interpreter();
        if (this.classLoader != null) {
            interpreter.setClassLoader(this.classLoader);
        }
        for (int r = 0; r < variables.length; ++r) {
            interpreter.set(variables[r], variableValues[r]);
        }
        JavaCodeFragment fragment = this.compileExpressionToJava(expression);
        StringBuilder sb = new StringBuilder();
        sb.append(fragment.getImportDeclaration().toString());
        sb.append(System.lineSeparator());
        sb.append(fragment.getSourcecode());
        return interpreter.eval(sb.toString());
    }

    public Object evaluate(JavaCodeFragment javaCodeFragment) throws Exception {
        Interpreter interpreter = new Interpreter();
        if (this.classLoader != null) {
            interpreter.setClassLoader(this.classLoader);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(javaCodeFragment);
        return interpreter.eval(sb.toString());
    }

    private JavaCodeFragment compileExpressionToJava(String expression) throws Exception {
        CompilationResult result = this.compiler.compile(expression);
        if (result.failed()) {
            throw new Exception(result.getMessages().toString());
        }
        return (JavaCodeFragment)result.getCodeFragment();
    }
}

