/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.operations;

import org.faktorips.codegen.CodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.fl.BinaryOperation;
import org.faktorips.fl.ExprCompiler;
import org.faktorips.fl.Operation;
import org.faktorips.util.ArgumentCheck;

public abstract class AbstractBinaryOperation<T extends CodeFragment>
implements BinaryOperation<T> {
    private ExprCompiler<T> compiler;
    private String operator;
    private Datatype lhsDatatype;
    private Datatype rhsDatatype;

    public AbstractBinaryOperation(Operation operation) {
        this(operation.getOperator(), operation.getLhs(), operation.getRhs());
    }

    public AbstractBinaryOperation(String operator, Datatype lhs, Datatype rhs) {
        ArgumentCheck.notNull((Object)operator);
        ArgumentCheck.notNull((Object)lhs);
        ArgumentCheck.notNull((Object)rhs);
        this.operator = operator;
        this.lhsDatatype = lhs;
        this.rhsDatatype = rhs;
    }

    @Override
    public void setCompiler(ExprCompiler<T> compiler) {
        ArgumentCheck.notNull(compiler);
        this.compiler = compiler;
    }

    @Override
    public ExprCompiler<T> getCompiler() {
        return this.compiler;
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public Datatype getLhsDatatype() {
        return this.lhsDatatype;
    }

    @Override
    public Datatype getRhsDatatype() {
        return this.rhsDatatype;
    }
}

