/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl;

import java.util.Objects;
import org.faktorips.codegen.CodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.fl.CompilationResult;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;

public abstract class AbstractCompilationResult<T extends CodeFragment>
implements CompilationResult<T> {
    private T codeFragment;
    private MessageList messages;
    private Datatype datatype;

    public AbstractCompilationResult(T sourcecode, Datatype datatype, MessageList messages) {
        this.codeFragment = sourcecode;
        this.datatype = datatype;
        this.messages = messages;
    }

    public AbstractCompilationResult(T sourcecode, Datatype datatype) {
        this.codeFragment = sourcecode;
        this.datatype = datatype;
        this.messages = new MessageList();
    }

    public AbstractCompilationResult(Message message, T codeFragment) {
        this.messages = new MessageList(message);
        this.codeFragment = codeFragment;
    }

    public AbstractCompilationResult(T codeFragment) {
        this.codeFragment = codeFragment;
        this.messages = new MessageList();
    }

    public void add(CompilationResult<T> result) {
        this.codeFragment.append(result.getCodeFragment());
        this.messages.add(result.getMessages());
    }

    @Override
    public T getCodeFragment() {
        return this.codeFragment;
    }

    public void setCodeFragment(T code) {
        this.codeFragment = code;
    }

    public void addCodeFragment(T code) {
        this.codeFragment.append(code);
    }

    public void addCodeFragment(String code) {
        this.codeFragment.append(code);
    }

    public void setDatatype(Datatype newType) {
        this.datatype = newType;
    }

    @Override
    public Datatype getDatatype() {
        return this.datatype;
    }

    @Override
    public MessageList getMessages() {
        return this.messages;
    }

    public void addMessage(Message msg) {
        this.messages.add(msg);
    }

    public void addMessages(MessageList list) {
        this.messages.add(list);
    }

    @Override
    public boolean successfull() {
        return !this.messages.containsErrorMsg();
    }

    @Override
    public boolean failed() {
        return this.messages.containsErrorMsg();
    }

    public int hashCode() {
        return Objects.hash(this.codeFragment, this.datatype, this.messages);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AbstractCompilationResult)) {
            return false;
        }
        AbstractCompilationResult other = (AbstractCompilationResult)obj;
        return Objects.equals(this.codeFragment, other.codeFragment) && Objects.equals(this.datatype, other.datatype) && Objects.equals(this.messages, other.messages);
    }

    public String toString() {
        return "Datatype: " + (this.datatype == null ? "null" : this.datatype.toString()) + System.lineSeparator() + this.messages.toString() + this.codeFragment.toString();
    }

    public final Datatype[] getDatatypes(CompilationResult<T>[] results) {
        Datatype[] types = new Datatype[results.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = results[i].getDatatype();
        }
        return types;
    }
}

