/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.functions;

import org.faktorips.codegen.CodeFragment;
import org.faktorips.codegen.ConversionCodeGenerator;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.fl.functions.AbstractFlFunction;
import org.faktorips.fl.functions.Messages;
import org.faktorips.runtime.Message;
import org.faktorips.util.ArgumentCheck;

public abstract class MinMaxNativeTypes
extends AbstractFlFunction {
    private String functionName = null;
    private String errorCodeSuffix = null;
    private Datatype functionDatatype = null;

    public MinMaxNativeTypes(String name, String description, Datatype datatype, boolean isMax) {
        super(name, description, datatype, new Datatype[]{datatype, datatype});
        ArgumentCheck.notNull((Object)datatype);
        this.functionDatatype = datatype;
        this.functionName = isMax ? "max" : "min";
        this.errorCodeSuffix = isMax ? "MAX" : "MIN";
    }

    protected String getFunctionName() {
        return this.functionName;
    }

    @Override
    public boolean match(String name, Datatype[] otherArgTypes) {
        if (!this.getName().equals(name)) {
            return false;
        }
        Datatype[] args = this.getArgTypes();
        if (args.length != otherArgTypes.length) {
            return false;
        }
        for (int i = 0; i < otherArgTypes.length; ++i) {
            ValueDatatype other;
            Datatype datatype;
            ValueDatatype argType;
            if (args[i].equals(otherArgTypes[i]) || ((argType = (ValueDatatype)args[i]).isPrimitive() ? argType.getWrapperType().equals(otherArgTypes[i]) : (datatype = otherArgTypes[i]) instanceof ValueDatatype && argType.equals((other = (ValueDatatype)datatype).getWrapperType()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public CompilationResult<JavaCodeFragment> compile(CompilationResult<JavaCodeFragment>[] argResults) {
        ArgumentCheck.length((Object[])argResults, (int)2);
        ConversionCodeGenerator ccg = this.getCompiler().getConversionCodeGenerator();
        Datatype datatype1 = argResults[0].getDatatype();
        Datatype datatype2 = argResults[1].getDatatype();
        CompilationResult<JavaCodeFragment> first = this.convertIfNecessay(datatype1, ccg, argResults[0]);
        if (first == null) {
            return this.createErrorCompilationResult(datatype1);
        }
        CompilationResult<JavaCodeFragment> second = this.convertIfNecessay(datatype2, ccg, argResults[1]);
        if (second == null) {
            return this.createErrorCompilationResult(datatype2);
        }
        JavaCodeFragment fragment = new JavaCodeFragment();
        this.writeBody(fragment, first, second);
        CompilationResultImpl result = new CompilationResultImpl(fragment, this.functionDatatype);
        result.addMessages(argResults[0].getMessages());
        result.addMessages(argResults[1].getMessages());
        return result;
    }

    protected abstract void writeBody(JavaCodeFragment var1, CompilationResult<JavaCodeFragment> var2, CompilationResult<JavaCodeFragment> var3);

    private CompilationResult<JavaCodeFragment> createErrorCompilationResult(Datatype datatype) {
        String code = "FLC-" + this.errorCodeSuffix;
        String text = Messages.INSTANCE.getString(code, new Object[]{datatype});
        Message msg = Message.newError((String)code, (String)text);
        return new CompilationResultImpl(msg);
    }

    private CompilationResult<JavaCodeFragment> convertIfNecessay(Datatype datatype, ConversionCodeGenerator<JavaCodeFragment> ccg, CompilationResult<JavaCodeFragment> argResult) {
        if (!this.functionDatatype.equals(datatype)) {
            if (ccg.canConvert(datatype, this.functionDatatype)) {
                JavaCodeFragment converted = (JavaCodeFragment)ccg.getConversionCode(datatype, this.functionDatatype, (CodeFragment)argResult.getCodeFragment());
                CompilationResultImpl newResult = new CompilationResultImpl(converted, this.functionDatatype);
                newResult.addMessages(argResult.getMessages());
                return newResult;
            }
            return null;
        }
        return argResult;
    }
}

