/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.functions;

import org.faktorips.codegen.CodeFragment;
import org.faktorips.codegen.ConversionCodeGenerator;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.fl.FunctionSignatures;
import org.faktorips.fl.functions.AbstractFlFunction;
import org.faktorips.util.ArgumentCheck;

public class SqrtDecimal
extends AbstractFlFunction {
    private static final String MATH_SQRT = "Math.sqrt";
    private final ConversionCodeGenerator<JavaCodeFragment> conversionCodeGenerator = ConversionCodeGenerator.getDefault();

    public SqrtDecimal(String name, String description) {
        super(name, description, FunctionSignatures.SqrtDecimal);
    }

    @Override
    public CompilationResult<JavaCodeFragment> compile(CompilationResult<JavaCodeFragment>[] argResults) {
        ArgumentCheck.length((Object[])argResults, (int)1);
        JavaCodeFragment fragment = new JavaCodeFragment();
        JavaCodeFragment fragmentResult = new JavaCodeFragment();
        fragment.append(MATH_SQRT);
        fragment.append('(');
        fragment.append(this.getConversionCodeDecimalDouble(argResults[0].getCodeFragment()));
        fragment.append(')');
        fragmentResult.append(this.getConversionCodeDoubleDecimal(fragment));
        CompilationResultImpl result = this.createCompilationResultImpl(fragmentResult);
        result.addMessages(argResults[0].getMessages());
        return result;
    }

    private CompilationResultImpl createCompilationResultImpl(JavaCodeFragment fragmentResult) {
        return new CompilationResultImpl(fragmentResult, (Datatype)Datatype.DECIMAL);
    }

    private JavaCodeFragment getConversionCodeDecimalDouble(JavaCodeFragment fragment) {
        return (JavaCodeFragment)this.conversionCodeGenerator.getConversionCode((Datatype)Datatype.DECIMAL, (Datatype)Datatype.DOUBLE, (CodeFragment)fragment);
    }

    private JavaCodeFragment getConversionCodeDoubleDecimal(JavaCodeFragment fragment) {
        return (JavaCodeFragment)this.conversionCodeGenerator.getConversionCode((Datatype)Datatype.DOUBLE, (Datatype)Datatype.DECIMAL, (CodeFragment)fragment);
    }
}

