/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.functions;

import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ListOfTypeDatatype;
import org.faktorips.fl.AbstractCompilationResult;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.fl.FunctionSignatures;
import org.faktorips.fl.functions.AbstractFlFunction;
import org.faktorips.fl.functions.Messages;
import org.faktorips.runtime.Message;
import org.faktorips.util.ArgumentCheck;

public abstract class AbstractListFunction
extends AbstractFlFunction {
    private static final String MSG_CODE_INVALID_DATATYPE = "FLC-LIST_FUNCTION_INVALID_DATATYPE";

    public AbstractListFunction(String name, String description, FunctionSignatures signature) {
        super(name, description, signature);
    }

    @Override
    public CompilationResult<JavaCodeFragment> compile(CompilationResult<JavaCodeFragment>[] argResults) {
        ArgumentCheck.length((Object[])argResults, (int)1);
        AbstractCompilationResult<JavaCodeFragment> listArgument = this.getListArgument(argResults);
        Datatype datatype = this.getBasicType(listArgument);
        CompilationResult<JavaCodeFragment> datatypeResult = this.validateBasicDatatype(datatype);
        if (this.compilationFailed(datatypeResult)) {
            return datatypeResult;
        }
        return this.generateFunctionCode(listArgument);
    }

    protected AbstractCompilationResult<JavaCodeFragment> getListArgument(CompilationResult<JavaCodeFragment>[] argResults) {
        return (AbstractCompilationResult)argResults[0];
    }

    private boolean compilationFailed(CompilationResult<JavaCodeFragment> datatypeResult) {
        return datatypeResult != null && datatypeResult.failed();
    }

    protected CompilationResult<JavaCodeFragment> validateBasicDatatype(Datatype basicDatatype) {
        return null;
    }

    protected CompilationResult<JavaCodeFragment> generateFunctionCode(CompilationResult<JavaCodeFragment> listArgument) {
        JavaCodeFragment fragment = new JavaCodeFragment();
        Datatype datatype = this.getBasicType(listArgument);
        CompilationResultImpl arg1Result = new CompilationResultImpl("currentResult", datatype);
        CompilationResultImpl arg2Result = new CompilationResultImpl("nextValue", datatype);
        String datatypeClassName = this.getJavaClassName(datatype);
        fragment.append("new ");
        fragment.appendClassName("org.faktorips.runtime.formula.FormulaEvaluatorUtil.FunctionWithListAsArgumentHelper");
        fragment.append("<");
        fragment.appendClassName(datatypeClassName);
        fragment.append(">(){\n@Override public ");
        fragment.appendClassName(datatypeClassName);
        fragment.append(" getPreliminaryResult(");
        fragment.appendClassName(datatypeClassName);
        fragment.append(" currentResult, ");
        fragment.appendClassName(datatypeClassName);
        fragment.append(" nextValue){return ");
        CompilationResult<JavaCodeFragment> functionCall = this.generateFunctionCall(arg1Result, arg2Result);
        if (functionCall.failed()) {
            String messageText = Messages.INSTANCE.getString(MSG_CODE_INVALID_DATATYPE, new Object[]{this.getName(), datatype.getName()});
            return new CompilationResultImpl(Message.newError((String)MSG_CODE_INVALID_DATATYPE, (String)messageText));
        }
        fragment.append(functionCall.getCodeFragment());
        fragment.append(";}\n@Override public ");
        fragment.appendClassName(datatypeClassName);
        fragment.append(" getFallBackValue(){");
        fragment.append(this.generateReturnFallBackValueCall(datatype));
        fragment.append(";}}.getResult(");
        fragment.append(listArgument.getCodeFragment());
        fragment.append(")");
        return this.createCompilationResult(listArgument, fragment);
    }

    protected abstract JavaCodeFragment generateReturnFallBackValueCall(Datatype var1);

    protected CompilationResult<JavaCodeFragment> generateFunctionCall(CompilationResultImpl argument1, CompilationResultImpl argument2) {
        CompilationResultImpl[] arguments = new CompilationResultImpl[]{argument1, argument2};
        Datatype[] datatypes = new Datatype[]{argument1.getDatatype(), argument2.getDatatype()};
        return this.getCompiler().getMatchingFunctionUsingConversion(arguments, datatypes, this.getName());
    }

    protected CompilationResultImpl createCompilationResult(CompilationResult<JavaCodeFragment> listArgument, JavaCodeFragment fragment) {
        Datatype basicDatatype = this.getBasicType(listArgument);
        CompilationResultImpl result = new CompilationResultImpl(fragment, basicDatatype);
        result.addMessages(listArgument.getMessages());
        return result;
    }

    protected Datatype getBasicType(CompilationResult<JavaCodeFragment> listArgument) {
        ListOfTypeDatatype listDatatype = (ListOfTypeDatatype)listArgument.getDatatype();
        return listDatatype.getBasicDatatype();
    }
}

