/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.functions;

import org.faktorips.codegen.DatatypeHelper;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ListOfTypeDatatype;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.fl.FunctionSignatures;
import org.faktorips.fl.functions.AbstractFlFunction;

public class Exists
extends AbstractFlFunction {
    public static final String ERROR_MESSAGE_CODE = "FLC-EXISTS";

    public Exists(String name, String description) {
        super(name, description, FunctionSignatures.Exists);
    }

    @Override
    public CompilationResult<JavaCodeFragment> compile(CompilationResult<JavaCodeFragment>[] argResults) {
        Datatype argType = argResults[0].getDatatype();
        if (argType.isPrimitive()) {
            return new CompilationResultImpl("true", (Datatype)Datatype.PRIMITIVE_BOOLEAN);
        }
        JavaCodeFragment code = new JavaCodeFragment();
        code.append("new ");
        code.appendClassName("org.faktorips.runtime.formula.FormulaEvaluatorUtil.ExistsHelper");
        code.append("(){@Override\nprotected boolean existsInternal(){ return ");
        if (argType instanceof ListOfTypeDatatype) {
            code.append("!");
            code.append(argResults[0].getCodeFragment());
            code.append(".isEmpty()");
        } else if (argType.hasNullObject()) {
            code.append("!");
            DatatypeHelper helper = this.getCompiler().getDatatypeHelper(argType);
            code.append((JavaCodeFragment)helper.nullExpression());
            code.append(".equals(");
            code.append(argResults[0].getCodeFragment());
            code.append(")");
        } else {
            code.append(argResults[0].getCodeFragment());
            code.append("!=null");
        }
        code.append(";}}.exists()");
        return new CompilationResultImpl(code, (Datatype)Datatype.PRIMITIVE_BOOLEAN);
    }
}

