/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.functions;

import java.lang.reflect.Method;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.ArrayOfValueDatatype;
import org.faktorips.datatype.Datatype;
import org.faktorips.fl.BeanDatatype;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.fl.FunctionSignatures;
import org.faktorips.fl.PropertyDatatype;
import org.faktorips.fl.functions.AbstractFlFunction;
import org.faktorips.fl.functions.Messages;
import org.faktorips.runtime.Message;
import org.faktorips.util.ArgumentCheck;
import org.faktorips.values.Decimal;

public class SumBeanArrayPropertyFct
extends AbstractFlFunction {
    public static final String ERROR_MESSAGE_CODE = "FLC-SUM-BEAN-ARRAY-PROPERTYFCT";

    public SumBeanArrayPropertyFct() {
        super("SUM", "", FunctionSignatures.SumBeanArrayPropertyFct);
    }

    @Override
    public CompilationResult<JavaCodeFragment> compile(CompilationResult<JavaCodeFragment>[] argResults) {
        ArgumentCheck.notNull(argResults[0]);
        ArgumentCheck.notNull(argResults[1]);
        ArrayOfValueDatatype array = (ArrayOfValueDatatype)argResults[0].getDatatype();
        BeanDatatype bean = (BeanDatatype)array.getBasicDatatype();
        PropertyDatatype property = (PropertyDatatype)argResults[1].getDatatype();
        if (bean.getProperty(property.getName()) == null) {
            String text = Messages.INSTANCE.getString(ERROR_MESSAGE_CODE, new Object[]{bean, property});
            Message msg = Message.newError((String)ERROR_MESSAGE_CODE, (String)text);
            return new CompilationResultImpl(msg);
        }
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.appendClassName(SumBeanArrayPropertyFct.class);
        fragment.append('.');
        fragment.append("sumDecimal(");
        fragment.append(argResults[0].getCodeFragment());
        fragment.append(", ");
        fragment.appendQuoted(property.getGetterMethod());
        fragment.append(")");
        CompilationResultImpl result = new CompilationResultImpl(fragment, (Datatype)Datatype.DECIMAL);
        result.addMessages(argResults[0].getMessages());
        result.addMessages(argResults[1].getMessages());
        return result;
    }

    public static final Decimal sumDecimal(Object[] beans, String getterMethod) {
        if (beans == null) {
            return Decimal.NULL;
        }
        if (beans.length == 0) {
            return Decimal.ZERO;
        }
        try {
            Decimal sum = Decimal.ZERO;
            Method method = beans[0].getClass().getMethod(getterMethod, new Class[0]);
            Object[] params = new Object[]{};
            for (Object bean : beans) {
                Decimal value = (Decimal)method.invoke(bean, params);
                sum = sum.add(value);
            }
            return sum;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

